package com.singularsys.jeptests;

import com.singularsys.jep.Jep;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTable;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.configurableparser.ConfigurableParser;
import com.singularsys.jep.parser.Node;

/**
 * Tests for the configurable parser.
 */
public class CPTest extends JepTest {

	public CPTest(String name) {
		super(name);
	}

	@Override
	public void setUp() {
		this.jep = new Jep();
		jep.setComponent(new ConfigurableParser());
	}

	/**
	 * Tests the addOperator method
	 * 
	 * @throws ParseException
	 */
	public void testAddOp() throws ParseException {
		OperatorTable ot = jep.getOperatorTable();
		Operator preinc  = new Operator("preinc",  "++", null, Operator.PREFIX + Operator.UNARY);
		Operator postinc = new Operator("postinc", "++", null, Operator.SUFFIX + Operator.UNARY);
		Operator predec  = new Operator("predec",  "--", null, Operator.PREFIX + Operator.UNARY);
		Operator postdec = new Operator("postdec", "--", null, Operator.SUFFIX + Operator.UNARY);
		Operator bitcomp = new Operator("bitcomp", "~",  null, Operator.PREFIX + Operator.UNARY);
		Operator lshift  = new Operator("<<",  null, Operator.BINARY + Operator.LEFT);
		Operator rshift  = new Operator(">>",  null, Operator.BINARY + Operator.LEFT);
		Operator rshift0 = new Operator(">>>", null, Operator.BINARY + Operator.LEFT);
		Operator bitand  = new Operator("&", null, Operator.BINARY + Operator.LEFT);
		Operator bitor   = new Operator("|", null, Operator.BINARY + Operator.LEFT);
		Operator bitxor  = new Operator("^", null, Operator.BINARY + Operator.LEFT);

		ot.addOperator(ot.getNumOps(), preinc,  ot.getUMinus());
		ot.addOperator(ot.getNumOps(), postinc, preinc);
		ot.addOperator(ot.getNumOps(), predec,  preinc);
		ot.addOperator(ot.getNumOps(), postdec, preinc);
		ot.addOperator(ot.getNumOps(), bitcomp, ot.getNot());
		ot.insertOperator(ot.getNumOps(), lshift, ot.getLT());
		ot.addOperator(ot.getNumOps(), rshift,  lshift);
		ot.addOperator(ot.getNumOps(), rshift0, lshift);
		ot.appendOperator(ot.getNumOps(), bitand, ot.getEQ());
		ot.removeOperator(ot.getPower());
		ot.appendOperator(ot.getNumOps(), bitxor, bitand);
		ot.appendOperator(ot.getNumOps(), bitor, bitxor);
		
		jep.reinitializeComponents();
		
		Node n = jep.parse("x=1");
		n = jep.parse("++x");
		nodeTest(n, preinc);
		n = jep.parse("x++");
		nodeTest(n, postinc);
		n = jep.parse("--x");
		nodeTest(n, predec);
		n = jep.parse("x--");
		nodeTest(n, postdec);
		n = jep.parse("-x");
		nodeTest(n, ot.getUMinus());
	}
}
