package com.singularsys.jepexamples.consoles;

import java.util.ArrayList;
import java.util.List;

import com.singularsys.jep.Jep;
import com.singularsys.jep.configurableparser.ConfigurableParser;
import com.singularsys.jep.configurableparser.TokenFilter;
import com.singularsys.jep.configurableparser.WhiteSpaceCommentFilter;
import com.singularsys.jep.configurableparser.matchers.ArrayAccessGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.CommentTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.FunctionGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.GrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.IdentifierTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.ListGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.ListOrBracketGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.NumberTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.OperatorTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.StringTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.SymbolTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.TerminatorTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.TokenMatcher;
import com.singularsys.jep.configurableparser.matchers.WhiteSpaceTokenMatcher;
import com.singularsys.jep.configurableparser.tokens.SymbolToken;

/**
 * A console which illustrates a different syntax for vectors using mathematical (1,2,3) notation.
the tokenizer

 */
public class VectorConsole extends Console {
	private static final long serialVersionUID = 300L;

	public VectorConsole() {
	}

	@Override
	public void initialise() {
		List<TokenMatcher> m = new ArrayList<TokenMatcher>();
		List<TokenFilter> filters = new ArrayList<TokenFilter>();
		List<GrammarMatcher> gm = new ArrayList<GrammarMatcher>();

		m.add(CommentTokenMatcher.hashCommentMatcher());
		m.add(CommentTokenMatcher.slashSlashCommentMatcher());
		m.add(CommentTokenMatcher.slashStarCommentMatcher());
		m.add(CommentTokenMatcher.multiLineSlashStarCommentMatcher());
		
		// match different types of string, ' and "
		m.add(StringTokenMatcher.doubleQuoteStringMatcher());
		//m.add(StringTokenMatcher.singleQuoteStringMatcher());

		// match whitespace
		m.add(WhiteSpaceTokenMatcher.defaultWhiteSpaceTokenMatcher());
		
		// match numbers
		m.add(NumberTokenMatcher.exponentNumberTokenMatcher());
		
		// match variable or function names
		m.add(IdentifierTokenMatcher.basicIndetifierMatcher());
		
		// match operators in the OperatorTable
		OperatorTokenMatcher otm = new OperatorTokenMatcher();
		m.add(otm);

		SymbolToken ropen = new SymbolToken("(",true);
		SymbolToken rclose = new SymbolToken(")");
		SymbolToken sopen = new SymbolToken("[",true);
		SymbolToken sclose = new SymbolToken("]");
		SymbolToken comma = new SymbolToken(",");
		SymbolTokenMatcher stm = new SymbolTokenMatcher();
		stm.add(ropen);
		stm.add(rclose);
		stm.add(sopen);
		stm.add(sclose);
		stm.add(comma);
		m.add(stm);
		
		m.add(TerminatorTokenMatcher.SemiColonTerminalMatcher());
	
		// remove comments
		filters.add(new WhiteSpaceCommentFilter());
		
		gm.add(new ListOrBracketGrammarMatcher(ropen,rclose,comma));
		gm.add(new FunctionGrammarMatcher(ropen,rclose,comma));
		gm.add(new ListGrammarMatcher(sopen,sclose,comma));
		gm.add(new ArrayAccessGrammarMatcher(sopen,sclose));

		jep = new Jep();
		jep.setComponent(new ConfigurableParser(m,filters,gm));
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		VectorConsole vc = new VectorConsole();
		vc.run(args);

	}

}
