/*
Created 2 Nov 2006 - Richard Morris
*/
package com.singularsys.jepexamples.consoles;

import com.singularsys.jep.JepException;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.PrefixTreeDumper;

public class PrefixDumperConsole extends Console {
	private static final long serialVersionUID = 1L;
	PrefixTreeDumper dumper;
	//ExpressionSerializer ser=null;
	public static void main(String[] args)
	{
		Console c = new PrefixDumperConsole();
		c.run(args);
	}

	@Override
	public void initialise() {
		super.initialise();
		dumper = new PrefixTreeDumper();
		//ser = new ExpressionSerializer(this.jep);
	}

	@Override
	public void processEquation(Node node) throws JepException {
		try {
		    Object value = this.jep.evaluate(node);
		    System.out.println(value);
		    dumper.dump(node);
		} catch (Exception e) {
			System.err.println(e.getMessage());
			e.printStackTrace();
		}
	}
	
	
}
