/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.Jep;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.OperatorTable;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Parser;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.VariableTable;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import com.singularsys.jep.standard.StandardFunctionTable;
import com.singularsys.jep.walkers.PrefixTreeDumper;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;

@Deprecated
public class JEP {
    private Jep jep = new Jep();
    protected ArrayList<String> errorList = new ArrayList();
    private Node topNode;
    protected boolean traverse = false;

    public JEP() {
    }

    public JEP(boolean bl, boolean bl2, boolean bl3, NumberFactory numberFactory) {
        this.traverse = bl;
        this.jep.setAllowUndeclared(bl2);
        this.jep.setImplicitMul(bl3);
        if (numberFactory != null) {
            this.jep.setComponent(numberFactory);
        }
    }

    public void initSymTab() {
        VariableTable variableTable = this.jep.getVariableTable();
        variableTable.clear();
    }

    public void initFunTab() {
        FunctionTable functionTable = this.jep.getFunctionTable();
        functionTable.clear();
    }

    public void addStandardFunctions() {
        this.jep.setComponent(new StandardFunctionTable());
    }

    public void addStandardConstants() {
        this.jep.addStandardConstants();
    }

    public void addComplex() {
        this.addVariable("i", 0.0, 1.0);
    }

    public void addFunction(String string, PostfixMathCommandI postfixMathCommandI) {
        this.jep.addFunction(string, postfixMathCommandI);
    }

    public Complex addVariable(String string, double d, double d2) {
        Complex complex = new Complex(d, d2);
        this.addVariable(string, complex);
        return complex;
    }

    public void addVariable(String string, Object object) {
        this.jep.addVariable(string, object);
    }

    public Object getVarValue(String string) {
        System.out.println("getVarValue: " + string + "(" + this.jep.getVariable(string).hashCode() + ")");
        return this.jep.getVariable(string).getValue();
    }

    public void setTraverse(boolean bl) {
        this.traverse = bl;
    }

    public boolean getTraverse() {
        return this.traverse;
    }

    public void setImplicitMul(boolean bl) {
        this.jep.setImplicitMul(bl);
    }

    public boolean getImplicitMul() {
        return this.jep.getImplicitMul();
    }

    public void setAllowUndeclared(boolean bl) {
        this.jep.setAllowUndeclared(bl);
    }

    public boolean getAllowUndeclared() {
        return this.jep.getAllowUndeclared();
    }

    public Node parseExpression(String string) {
        StringReader stringReader = new StringReader(string);
        try {
            this.errorList.clear();
            this.topNode = this.jep.parse(stringReader);
            if (this.hasError()) {
                this.topNode = null;
            }
        }
        catch (Throwable throwable) {
            this.topNode = null;
            if (throwable instanceof ParseException) {
                this.errorList.add(((ParseException)throwable).getMessage());
            }
            this.errorList.add("Syntax error");
        }
        if (this.traverse && !this.hasError()) {
            PrefixTreeDumper prefixTreeDumper = new PrefixTreeDumper();
            try {
                prefixTreeDumper.walk(this.topNode);
            }
            catch (Exception exception) {
                this.errorList.add(exception.getMessage());
            }
        }
        return this.topNode;
    }

    public double getValue() {
        Object object = this.getValueAsObject();
        if (object == null) {
            return Double.NaN;
        }
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            if (complex.im() != 0.0) {
                return Double.NaN;
            }
            return complex.re();
        }
        if (object != null && object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return Double.NaN;
    }

    public Complex getComplexValue() {
        Object object = this.getValueAsObject();
        if (object == null) {
            return null;
        }
        if (object instanceof Complex) {
            return (Complex)object;
        }
        if (object instanceof Number) {
            return new Complex(((Number)object).doubleValue(), 0.0);
        }
        return null;
    }

    public Object getValueAsObject() {
        Object object;
        if (this.topNode == null) {
            return null;
        }
        try {
            object = this.jep.evaluate(this.topNode);
        }
        catch (EvaluationException evaluationException) {
            this.errorList.add("Error during evaluation: " + evaluationException.getMessage());
            return null;
        }
        catch (RuntimeException runtimeException) {
            this.errorList.add(runtimeException.getClass().getName() + ": " + runtimeException.getMessage());
            return null;
        }
        return object;
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public String getErrorInfo() {
        if (this.hasError()) {
            String string = "";
            Iterator<String> iterator = this.errorList.iterator();
            while (iterator.hasNext()) {
                string = string + iterator.next() + "\n";
            }
            return string;
        }
        return null;
    }

    public VariableTable getSymbolTable() {
        return this.jep.getVariableTable();
    }

    public FunctionTable getFunctionTable() {
        return this.jep.getFunctionTable();
    }

    public NumberFactory getNumberFactory() {
        return this.jep.getNumberFactory();
    }

    public OperatorTable getOperatorSet() {
        return this.jep.getOperatorTable();
    }

    public Parser getParser() {
        return this.jep.getParser();
    }
}

