/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.walkers;

import com.singularsys.jep.JepException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.Variable;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.PostfixTreeWalker;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeAnalyzer
extends PostfixTreeWalker {
    Map<Variable, Integer> variables = new HashMap<Variable, Integer>();
    Map<String, Integer> functions = new HashMap<String, Integer>();
    Map<Operator, Integer> operators = new HashMap<Operator, Integer>();
    int maxDepth;
    int numNodes;
    int numFuns;
    int numOps;
    int numVars;
    int numConst;

    public String toString() {
        return "Nodes " + this.numNodes + " depth " + this.maxDepth + " Ops " + this.numOps + " Funs " + this.numFuns + " Vars " + this.numVars + " Const " + this.numConst;
    }

    public TreeAnalyzer(Node node) throws JepException {
        this.walk(node);
    }

    private TreeAnalyzer() {
    }

    @Override
    protected void visit(ASTFunNode aSTFunNode, int n, int n2) {
        ++this.numNodes;
        ++this.numFuns;
        this.maxDepth = n2 > this.maxDepth ? n2 : this.maxDepth;
        Integer n3 = this.functions.get(aSTFunNode.getName());
        n3 = n3 == null ? Integer.valueOf(1) : Integer.valueOf(n3 + 1);
        this.functions.put(aSTFunNode.getName(), n3);
    }

    @Override
    protected void visit(ASTOpNode aSTOpNode, int n, int n2) {
        ++this.numNodes;
        ++this.numOps;
        this.maxDepth = n2 > this.maxDepth ? n2 : this.maxDepth;
        Integer n3 = this.operators.get(aSTOpNode.getName());
        n3 = n3 == null ? Integer.valueOf(1) : Integer.valueOf(n3 + 1);
        this.operators.put(aSTOpNode.getOperator(), n3);
    }

    @Override
    protected void visit(ASTVarNode aSTVarNode, int n, int n2) {
        ++this.numNodes;
        ++this.numVars;
        this.maxDepth = n2 > this.maxDepth ? n2 : this.maxDepth;
        Integer n3 = this.variables.get(aSTVarNode.getName());
        n3 = n3 == null ? Integer.valueOf(1) : Integer.valueOf(n3 + 1);
        this.variables.put(aSTVarNode.getVar(), n3);
    }

    @Override
    protected void visit(ASTConstant aSTConstant, int n, int n2) {
        ++this.numNodes;
        ++this.numConst;
        this.maxDepth = n2 > this.maxDepth ? n2 : this.maxDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getNumConst() {
        return this.numConst;
    }

    public int getNumFunctions() {
        return this.numFuns;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public int getNumOperators() {
        return this.numOps;
    }

    public int getNumVariables() {
        return this.numVars;
    }

    public Map<Operator, Integer> getOperators() {
        return this.operators;
    }

    public Map<Variable, Integer> getVariables() {
        return this.variables;
    }

    public Map<String, Integer> getFunctions() {
        return this.functions;
    }
}

