/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.walkers;

import com.singularsys.jep.JepException;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.util.Stack;

public abstract class PrefixTreeWalker {
    Stack<NodeIndex> s = new Stack();
    int depth;

    public void walk(Node node) throws JepException {
        this.s.empty();
        int n = node.jjtGetNumChildren();
        this.visit(node, n, 0);
        this.depth = 1;
        this.s.push(new NodeIndex(node));
        while (!this.s.isEmpty()) {
            NodeIndex nodeIndex = this.s.peek();
            Node node2 = nodeIndex.getNext();
            if (node2 == null) {
                --this.depth;
                this.s.pop();
                continue;
            }
            int n2 = node2.jjtGetNumChildren();
            this.visit(node2, n2, this.depth);
            if (n2 <= 0) continue;
            ++this.depth;
            this.s.push(new NodeIndex(node2));
        }
    }

    private void visit(Node node, int n, int n2) throws JepException {
        if (node instanceof ASTConstant) {
            this.visit((ASTConstant)node, n, n2);
        } else if (node instanceof ASTVarNode) {
            this.visit((ASTVarNode)node, n, n2);
        } else if (node instanceof ASTOpNode) {
            this.visit((ASTOpNode)node, n, n2);
        } else if (node instanceof ASTFunNode) {
            this.visit((ASTFunNode)node, n, n2);
        } else {
            throw new JepException("Illegal type of node " + node.getClass().getName());
        }
    }

    protected abstract void visit(ASTFunNode var1, int var2, int var3) throws JepException;

    protected abstract void visit(ASTOpNode var1, int var2, int var3) throws JepException;

    protected abstract void visit(ASTVarNode var1, int var2, int var3) throws JepException;

    protected abstract void visit(ASTConstant var1, int var2, int var3) throws JepException;

    class NodeIndex {
        Node n;
        int pos;
        int max;

        public NodeIndex(Node node) {
            this.n = node;
            this.pos = -1;
            this.max = node.jjtGetNumChildren();
        }

        public Node getNext() {
            ++this.pos;
            if (this.pos >= this.max) {
                return null;
            }
            return this.n.jjtGetChild(this.pos);
        }

        public String toString() {
            return this.n.toString() + "\t" + this.max + "\t" + this.pos;
        }
    }
}

