/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.walkers;

import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepException;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.OperatorTable;
import com.singularsys.jep.ParserVisitor;
import com.singularsys.jep.VariableTable;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;

public class DoNothingVisitor
implements ParserVisitor {
    protected Jep jep;
    protected NodeFactory nf;
    protected VariableTable vt;
    protected FunctionTable ft;
    protected OperatorTable ot;

    private DoNothingVisitor() {
    }

    public DoNothingVisitor(Jep jep) {
        this.jep = jep;
        this.ft = jep.getFunctionTable();
        this.nf = jep.getNodeFactory();
        this.ot = jep.getOperatorTable();
        this.vt = jep.getVariableTable();
    }

    public Node visit(Node node) throws JepException {
        return this.visitNode(node, null);
    }

    public Node visitNode(Node node, Object object) throws JepException {
        if (node instanceof ASTConstant) {
            return (Node)this.visit((ASTConstant)node, object);
        }
        if (node instanceof ASTVarNode) {
            return (Node)this.visit((ASTVarNode)node, object);
        }
        if (node instanceof ASTOpNode) {
            return (Node)this.visit((ASTOpNode)node, object);
        }
        if (node instanceof ASTFunNode) {
            return (Node)this.visit((ASTFunNode)node, object);
        }
        throw new JepException("Illegal node type encountered " + node.getClass().getName());
    }

    protected Node[] visitChildren(Node node, Object object) throws JepException {
        int n = node.jjtGetNumChildren();
        Node[] nodeArray = new Node[n];
        for (int i = 0; i < n; ++i) {
            nodeArray[i] = this.visitNode(node.jjtGetChild(i), object);
        }
        return nodeArray;
    }

    public Object visit(ASTConstant aSTConstant, Object object) throws JepException {
        return aSTConstant;
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws JepException {
        return aSTVarNode;
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws JepException {
        Node[] nodeArray = this.visitChildren(aSTFunNode, object);
        this.copyChildrenIfNeeded(aSTFunNode, nodeArray);
        return aSTFunNode;
    }

    public Object visit(ASTOpNode aSTOpNode, Object object) throws JepException {
        Node[] nodeArray = this.visitChildren(aSTOpNode, object);
        this.copyChildrenIfNeeded(aSTOpNode, nodeArray);
        return aSTOpNode;
    }

    protected Node copyChildrenIfNeeded(Node node, Node[] nodeArray) throws JepException {
        int n = node.jjtGetNumChildren();
        if (n != nodeArray.length) {
            throw new JepException("copyChildrenIfNeeded: number of children of node not the same as supplied children");
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (node.jjtGetChild(i) == nodeArray[i]) continue;
            bl = true;
        }
        if (!bl) {
            return node;
        }
        if (node instanceof ASTOpNode) {
            return this.nf.buildOperatorNode(((ASTOpNode)node).getOperator(), nodeArray);
        }
        return this.nf.buildFunctionNode((ASTFunNode)node, nodeArray);
    }
}

