/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.standard;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.ParserVisitor;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Stack;

public class StandardEvaluator
implements Evaluator,
ParserVisitor {
    private static final long serialVersionUID = 300L;
    private transient Stack<Object> stack = new Stack();
    private boolean trapNullValues = true;

    public void init(Jep jep) {
    }

    public Object eval(Node node) throws EvaluationException {
        try {
            node.jjtAccept(this, null);
        }
        catch (EvaluationException evaluationException) {
            throw evaluationException;
        }
        catch (JepException jepException) {
            throw new EvaluationException(jepException);
        }
        Object object = this.stack.pop();
        return object;
    }

    public Object evaluate(Node node) throws EvaluationException {
        this.stack.clear();
        try {
            node.jjtAccept(this, null);
        }
        catch (EvaluationException evaluationException) {
            throw evaluationException;
        }
        catch (JepException jepException) {
            throw new EvaluationException(jepException);
        }
        if (this.stack.size() != 1) {
            throw new EvaluationException("Stack corrupted");
        }
        Object object = this.stack.pop();
        return object;
    }

    public Object visit(ASTConstant aSTConstant, Object object) throws EvaluationException {
        Object object2 = aSTConstant.getValue();
        this.stack.push(object2);
        return null;
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws EvaluationException {
        this.visitFun(aSTFunNode);
        return null;
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws EvaluationException {
        Variable variable = aSTVarNode.getVar();
        assert (variable != null);
        Object object2 = variable.getValue();
        if (this.trapNullValues && object2 == null) {
            String string = "Could not evaluate " + aSTVarNode.getName() + " - ";
            throw new EvaluationException(string + "variable not set.");
        }
        this.stack.push(object2);
        return object;
    }

    public Object visit(ASTOpNode aSTOpNode, Object object) throws EvaluationException {
        this.visitFun(aSTOpNode);
        return null;
    }

    protected void visitFun(ASTFunNode aSTFunNode) throws EvaluationException {
        int n;
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        if (postfixMathCommandI == null) {
            throw new EvaluationException("No function class associated with " + aSTFunNode.getName());
        }
        if (postfixMathCommandI instanceof CallbackEvaluationI) {
            Object object = ((CallbackEvaluationI)((Object)postfixMathCommandI)).evaluate(aSTFunNode, this);
            this.stack.push(object);
            return;
        }
        int n2 = aSTFunNode.jjtGetNumChildren();
        for (n = 0; n < n2; ++n) {
            Node node = aSTFunNode.jjtGetChild(n);
            try {
                node.jjtAccept(this, null);
                continue;
            }
            catch (JepException jepException) {
                throw new EvaluationException(jepException);
            }
        }
        n = postfixMathCommandI.getNumberOfParameters();
        if (n != -1 && n != n2) {
            throw new EvaluationException("Incorrect number of children " + n2 + ". Should have been " + n);
        }
        postfixMathCommandI.setCurNumberOfParameters(n2);
        postfixMathCommandI.run(this.stack);
    }

    public boolean isTrapNullValues() {
        return this.trapNullValues;
    }

    public void setTrapNullValues(boolean bl) {
        this.trapNullValues = bl;
    }

    public JepComponent getLightWeightInstance() {
        StandardEvaluator standardEvaluator = new StandardEvaluator();
        standardEvaluator.trapNullValues = this.trapNullValues;
        return standardEvaluator;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stack = new Stack();
    }
}

