/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.reals;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.reals.RealBinaryFunction;
import com.singularsys.jep.reals.RealNaryFunction;
import com.singularsys.jep.reals.RealNullaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Stack;

public class RealEvaluator
implements Evaluator {
    private static final long serialVersionUID = 300L;
    private transient Stack<Object> stack = new Stack();

    public Object evaluate(Node node) throws EvaluationException {
        this.stack.clear();
        double d = this.visit(node);
        return d;
    }

    public Object eval(Node node) throws EvaluationException {
        double d = this.visit(node);
        return d;
    }

    public void init(Jep jep) {
    }

    protected double visit(Node node) throws EvaluationException {
        if (node instanceof ASTConstant) {
            return this.visitConstant((ASTConstant)node);
        }
        if (node instanceof ASTVarNode) {
            return this.visitVariable((ASTVarNode)node);
        }
        if (node instanceof ASTFunNode) {
            return this.visitFunction((ASTFunNode)node);
        }
        throw new EvaluationException("Bad node type");
    }

    protected double[] visitChildren(ASTFunNode aSTFunNode) throws EvaluationException {
        double[] dArray = new double[aSTFunNode.jjtGetNumChildren()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.visit(aSTFunNode.jjtGetChild(i));
        }
        return dArray;
    }

    protected double visitFunction(ASTFunNode aSTFunNode) throws EvaluationException {
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        if (postfixMathCommandI == null) {
            throw new EvaluationException("PostfixMathCommand for " + aSTFunNode.getName() + " not found");
        }
        if (postfixMathCommandI instanceof CallbackEvaluationI) {
            Object object = ((CallbackEvaluationI)((Object)postfixMathCommandI)).evaluate(aSTFunNode, this);
            return RealEvaluator.fromObject(object);
        }
        int n = aSTFunNode.jjtGetNumChildren();
        switch (n) {
            case 0: {
                if (postfixMathCommandI instanceof RealNullaryFunction) {
                    double d = ((RealNullaryFunction)((Object)postfixMathCommandI)).evaluate();
                    return d;
                }
                if (postfixMathCommandI instanceof RealNaryFunction) {
                    double d = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(new double[0]);
                    return d;
                }
                postfixMathCommandI.setCurNumberOfParameters(0);
                postfixMathCommandI.run(this.stack);
                Object object = this.stack.pop();
                return RealEvaluator.fromObject(object);
            }
            case 1: {
                double d = this.visit(aSTFunNode.jjtGetChild(0));
                if (postfixMathCommandI instanceof RealUnaryFunction) {
                    double d2 = ((RealUnaryFunction)((Object)postfixMathCommandI)).evaluate(d);
                    return d2;
                }
                if (postfixMathCommandI instanceof RealNaryFunction) {
                    double d3 = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(new double[]{d});
                    return d3;
                }
                this.stack.push(new Double(d));
                postfixMathCommandI.setCurNumberOfParameters(1);
                postfixMathCommandI.run(this.stack);
                Object object = this.stack.pop();
                return RealEvaluator.fromObject(object);
            }
            case 2: {
                double d = this.visit(aSTFunNode.jjtGetChild(0));
                double d4 = this.visit(aSTFunNode.jjtGetChild(1));
                if (postfixMathCommandI instanceof RealBinaryFunction) {
                    double d5 = ((RealBinaryFunction)((Object)postfixMathCommandI)).evaluate(d, d4);
                    return d5;
                }
                if (postfixMathCommandI instanceof RealNaryFunction) {
                    double d6 = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(new double[]{d, d4});
                    return d6;
                }
                this.stack.push(d);
                this.stack.push(d4);
                postfixMathCommandI.setCurNumberOfParameters(2);
                postfixMathCommandI.run(this.stack);
                Object object = this.stack.pop();
                return RealEvaluator.fromObject(object);
            }
        }
        double[] dArray = this.visitChildren(aSTFunNode);
        if (postfixMathCommandI instanceof RealNaryFunction) {
            double d = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(dArray);
            return d;
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.stack.push(dArray[i]);
        }
        postfixMathCommandI.setCurNumberOfParameters(dArray.length);
        postfixMathCommandI.run(this.stack);
        Object object = this.stack.pop();
        return RealEvaluator.fromObject(object);
    }

    protected double visitVariable(ASTVarNode aSTVarNode) throws EvaluationException {
        Object object = aSTVarNode.getVar().getValue();
        if (object == null) {
            throw new EvaluationException("Variable " + aSTVarNode.getName() + " has a null value");
        }
        return RealEvaluator.fromObject(object);
    }

    protected double visitConstant(ASTConstant aSTConstant) throws EvaluationException {
        Object object = aSTConstant.getValue();
        return RealEvaluator.fromObject(object);
    }

    static double fromObject(Object object) throws EvaluationException {
        if (object == null) {
            throw new EvaluationException("Null value encountered");
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        throw new EvaluationException("Cannot convert " + object.getClass().getName() + " " + object + " to a double");
    }

    public JepComponent getLightWeightInstance() {
        return new RealEvaluator();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stack = new Stack();
    }
}

