/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.parser;

import com.singularsys.jep.JepException;
import com.singularsys.jep.Parser;
import com.singularsys.jep.ParserVisitor;
import com.singularsys.jep.parser.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;
    protected Map<String, Object> hooks;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Parser parser, int n) {
        this(n);
        this.parser = parser;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(ParserVisitor parserVisitor, Object object) throws JepException {
        throw new JepException("Illegal node type encountered");
    }

    public Object childrenAccept(ParserVisitor parserVisitor, Object object) throws JepException {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(parserVisitor, object);
            }
        }
        return object;
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public Object getHook(String string) {
        if (this.hooks == null) {
            return null;
        }
        return this.hooks.get(string);
    }

    public Object setHook(String string, Object object) {
        if (this.hooks == null) {
            this.hooks = new HashMap<String, Object>();
        }
        return this.hooks.put(string, object);
    }

    public Set<String> hookKeys() {
        if (this.hooks == null) {
            return null;
        }
        return this.hooks.keySet();
    }
}

