/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.Node;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroFunction
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;
    private int nParam;
    private String name;
    private String[] varNames;
    private String expression;
    protected transient Node topNode;
    private transient Evaluator ev;
    private transient Variable[] vars;

    public MacroFunction(String string, String[] stringArray, String string2) {
        this.numberOfParameters = this.nParam = stringArray.length;
        this.name = string;
        this.varNames = (String[])stringArray.clone();
        this.expression = string2;
        this.vars = new Variable[this.nParam];
    }

    public MacroFunction(String string, String string2, String string3) {
        this.numberOfParameters = 1;
        this.name = string;
        this.varNames = new String[]{string2};
        this.expression = string3;
        this.nParam = 1;
        this.vars = new Variable[this.nParam];
    }

    public void init(Jep jep) throws ParseException {
        for (int i = 0; i < this.nParam; ++i) {
            this.vars[i] = jep.addVariable(this.varNames[i]);
        }
        this.topNode = jep.parse(this.expression);
        this.ev = jep.getEvaluator();
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        if (this.topNode == null) {
            throw new EvaluationException("MacroFunction " + this.name + " init method must be used before evaluation");
        }
        Object[] objectArray = new Object[this.nParam];
        for (int i = this.nParam - 1; i >= 0; --i) {
            objectArray[i] = this.vars[i].getValue();
            this.vars[i].setValue(stack.pop());
        }
        Object object = this.ev.eval(this.topNode);
        stack.push(object);
        for (int i = this.nParam - 1; i >= 0; --i) {
            this.vars[i].setValue(objectArray[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.vars = new Variable[this.nParam];
    }

    public String getName() {
        return this.name;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public String[] getParameterNames() {
        return (String[])this.varNames.clone();
    }
}

