/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.configurableparser.TernaryOperator;
import com.singularsys.jep.functions.If;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.standard.StandardOperatorTable;
import java.util.Stack;

public class ExtendedOperatorSet
extends StandardOperatorTable {
    private static final long serialVersionUID = 300L;
    static int myNumOps = 25;
    public static final int OP_FACT = myNumOps++;
    public static final int OP_PERCENT = myNumOps++;
    public static final int OP_IF = myNumOps++;

    public ExtendedOperatorSet() {
        this.numOps = this.getNumOps();
        this.addOperator(OP_FACT, new Operator("FACT", "!", new Factorial(), 1029));
        this.addOperator(OP_PERCENT, new Operator("PERCENT", "%", new Percent(), 1029));
        this.addOperator(OP_IF, new TernaryOperator("IF", "?", ":", new If(), 32776));
        this.setPrecedenceTable(new int[][]{{OP_FACT, OP_PERCENT}, {3, 18, 4}, {9}, {5, 6, 7, 20, 21}, {1, 2}, {11, 13}, {10, 14}, {12}, {15}, {16}, {17}, {OP_IF}, {19}});
        this.setStandardOperatorRelations();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Percent
    extends PostfixMathCommand {
        private static final long serialVersionUID = 300L;

        public Percent() {
            this.numberOfParameters = 1;
        }

        @Override
        public void run(Stack<Object> stack) throws EvaluationException {
            double d = ((Number)stack.pop()).doubleValue();
            double d2 = d / 100.0;
            stack.push(d2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factorial
    extends PostfixMathCommand {
        private static final long serialVersionUID = 300L;

        public Factorial() {
            this.numberOfParameters = 1;
        }

        @Override
        public void run(Stack<Object> stack) throws EvaluationException {
            long l = ((Number)stack.pop()).longValue();
            long l2 = 1L;
            for (long i = 2L; i <= l; ++i) {
                l2 *= i;
            }
            Long l3 = l2;
            stack.push(l3);
        }
    }
}

