/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.reals.RealBinaryFunction;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subtract
extends PostfixMathCommand
implements RealBinaryFunction {
    private static final long serialVersionUID = 300L;

    public Subtract() {
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        Object object2 = stack.pop();
        stack.push(this.sub(object2, object));
    }

    public Object sub(Object object, Object object2) throws EvaluationException {
        if (object instanceof Complex) {
            if (object2 instanceof Complex) {
                return this.sub((Complex)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.sub((Complex)object, (Number)object2);
            }
        } else if (object instanceof Number) {
            if (object2 instanceof Complex) {
                return this.sub((Number)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.sub((Number)object, (Number)object2);
            }
        } else if (object instanceof Vector && object2 instanceof Vector) {
            return this.sub((Vector)object, (Vector)object2);
        }
        throw new EvaluationException("Invalid parameter type");
    }

    public Vector sub(Vector vector, Vector vector2) throws EvaluationException {
        if (vector.size() != vector2.size()) {
            throw new EvaluationException("Add: dimensions of vectors do not match, " + vector.size() + ", " + vector2.size());
        }
        Vector<Object> vector3 = new Vector<Object>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            vector3.add(i, this.sub(vector.get(i), vector2.get(i)));
        }
        return vector3;
    }

    public Double sub(Number number, Number number2) {
        return new Double(number.doubleValue() - number2.doubleValue());
    }

    public Complex sub(Complex complex, Complex complex2) {
        return new Complex(complex.re() - complex2.re(), complex.im() - complex2.im());
    }

    public Complex sub(Complex complex, Number number) {
        return new Complex(complex.re() - number.doubleValue(), complex.im());
    }

    public Complex sub(Number number, Complex complex) {
        return new Complex(number.doubleValue() - complex.re(), -complex.im());
    }

    @Override
    public double evaluate(double d, double d2) {
        return d - d2;
    }
}

