/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrictNaturalLogarithm
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;
    double logBase = 1.0;

    public StrictNaturalLogarithm() {
        this.numberOfParameters = 1;
    }

    public StrictNaturalLogarithm(double d) {
        this.numberOfParameters = 1;
        this.logBase = Math.log(d);
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        stack.push(this.ln(object));
    }

    public Object ln(Object object) throws EvaluationException {
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            return new Complex(Math.log(complex.abs()) / this.logBase, complex.arg());
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d >= 0.0) {
                return new Double(Math.log(d) / this.logBase);
            }
            return new Double(Double.NaN);
        }
        throw new EvaluationException("Invalid parameter type");
    }
}

