/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SquareRoot
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;

    public SquareRoot() {
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        stack.push(this.sqrt(object));
    }

    public Object sqrt(Object object) throws EvaluationException {
        if (object instanceof Complex) {
            return ((Complex)object).sqrt();
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d < 0.0) {
                return new Complex(d).sqrt();
            }
            return new Double(Math.sqrt(d));
        }
        throw new EvaluationException("Invalid parameter type");
    }
}

