/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Round
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;

    public Round() {
        this.numberOfParameters = -1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        if (this.curNumberOfParameters == 1) {
            Object object = stack.pop();
            stack.push(this.round(object));
        } else {
            Object object = stack.pop();
            Object object2 = stack.pop();
            stack.push(this.round(object2, object));
        }
    }

    private Object round(Object object, Object object2) throws EvaluationException {
        if (object instanceof Number && object2 instanceof Number) {
            int n = ((Number)object2).intValue();
            double d = ((Number)object).doubleValue();
            double d2 = Math.pow(10.0, n);
            return new Double(Math.rint(d * d2) / d2);
        }
        throw new EvaluationException("Invalid parameter type");
    }

    public Object round(Object object) throws EvaluationException {
        if (object instanceof Number) {
            return new Double(Math.rint(((Number)object).doubleValue()));
        }
        throw new EvaluationException("Invalid parameter type");
    }
}

