/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaturalLogarithm
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;

    public NaturalLogarithm() {
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        stack.push(this.ln(object));
    }

    public Object ln(Object object) throws EvaluationException {
        if (object instanceof Complex) {
            return ((Complex)object).log();
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d >= 0.0) {
                return new Double(Math.log(d));
            }
            if (d != d) {
                return new Double(Double.NaN);
            }
            Complex complex = new Complex(d);
            return complex.log();
        }
        throw new EvaluationException("Invalid parameter type");
    }
}

