/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.reals.RealBinaryFunction;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multiply
extends PostfixMathCommand
implements RealBinaryFunction {
    private static final long serialVersionUID = 300L;

    public Multiply() {
        this.numberOfParameters = -1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        for (int i = 1; i < this.curNumberOfParameters; ++i) {
            Object object2 = stack.pop();
            object = this.mul(object2, object);
        }
        stack.push(object);
    }

    public Object mul(Object object, Object object2) throws EvaluationException {
        if (object instanceof Complex) {
            if (object2 instanceof Complex) {
                return this.mul((Complex)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.mul((Complex)object, (Number)object2);
            }
            if (object2 instanceof Vector) {
                return this.mul((Object)((Complex)object), (Vector)object2);
            }
        } else if (object instanceof Number) {
            if (object2 instanceof Complex) {
                return this.mul((Complex)object2, (Number)object);
            }
            if (object2 instanceof Number) {
                return this.mul((Number)object, (Number)object2);
            }
            if (object2 instanceof Vector) {
                return this.mul((Object)((Number)object), (Vector)object2);
            }
        } else if (object instanceof Vector) {
            return this.mul((Vector)object, object2);
        }
        throw new EvaluationException("Invalid parameter type");
    }

    public Double mul(Number number, Number number2) {
        return new Double(number.doubleValue() * number2.doubleValue());
    }

    public Complex mul(Complex complex, Complex complex2) {
        return complex.mul(complex2);
    }

    public Complex mul(Complex complex, Number number) {
        return complex.mul(number.doubleValue());
    }

    public Vector mul(Vector vector, Object object) throws EvaluationException {
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(this.mul(vector.elementAt(i), object));
        }
        return vector2;
    }

    public Vector mul(Object object, Vector vector) throws EvaluationException {
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(this.mul(object, vector.elementAt(i)));
        }
        return vector2;
    }

    @Override
    public double evaluate(double d, double d2) {
        return d * d2;
    }
}

