/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.Comparative;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinMax
extends PostfixMathCommand {
    private static final long serialVersionUID = 310L;
    private Comparative comp;

    public MinMax(boolean bl) {
        this.comp = new Comparative(bl ? 0 : 1);
        this.numberOfParameters = -1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        Vector vector;
        this.checkStack(stack);
        if (this.curNumberOfParameters < 1) {
            this.throwAtLeastOneExcep();
        }
        if (this.curNumberOfParameters == 1 && stack.peek() instanceof Vector) {
            vector = (Vector)stack.pop();
        } else {
            vector = new Vector(this.curNumberOfParameters);
            for (int i = 0; i < this.curNumberOfParameters; ++i) {
                vector.add(stack.pop());
            }
        }
        if (vector.size() == 0) {
            this.throwAtLeastOneExcep();
        }
        stack.push(this.minmax(vector));
    }

    private void throwAtLeastOneExcep() throws EvaluationException {
        throw new EvaluationException("At least one argument is required");
    }

    public Object minmax(Vector vector) throws EvaluationException {
        Object e = vector.elementAt(0);
        for (int i = 1; i < vector.size(); ++i) {
            if (!this.comp.compare(vector.elementAt(i), e)) continue;
            e = vector.elementAt(i);
        }
        return e;
    }
}

