/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logical
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;
    int id;
    public static final int AND = 0;
    public static final int OR = 1;

    public Logical(int n) {
        this.id = n;
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        Boolean bl;
        double d;
        double d2;
        this.checkStack(stack);
        Object object = stack.pop();
        Object object2 = stack.pop();
        if (object2 instanceof Number) {
            d2 = ((Number)object2).doubleValue();
        } else if (object2 instanceof Boolean) {
            d2 = (Boolean)object2 != false ? 1.0 : 0.0;
        } else {
            throw new EvaluationException("Logical: require a number or Boolean value on lhs, have " + object2.getClass().getName());
        }
        if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else if (object instanceof Boolean) {
            d = (Boolean)object != false ? 1.0 : 0.0;
        } else {
            throw new EvaluationException("Logical: require a number or Boolean value on lhs, have " + object.getClass().getName());
        }
        switch (this.id) {
            case 0: {
                bl = d2 != 0.0 && d != 0.0;
                break;
            }
            case 1: {
                bl = d2 != 0.0 || d != 0.0;
                break;
            }
            default: {
                bl = Boolean.FALSE;
            }
        }
        stack.push(bl);
    }
}

