/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogBase2
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;
    private static final double LOG2 = Math.log(2.0);
    private static final Complex CLOG2 = new Complex(Math.log(2.0), 0.0);

    public LogBase2() {
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        stack.push(this.logbase2(object));
    }

    public Object logbase2(Object object) throws EvaluationException {
        if (object instanceof Complex) {
            return ((Complex)object).log().div(CLOG2);
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d >= 0.0) {
                return new Double(Math.log(d) / LOG2);
            }
            if (d != d) {
                return new Double(Double.NaN);
            }
            Complex complex = new Complex(d);
            return complex.log().div(CLOG2);
        }
        throw new EvaluationException("Invalid parameter type");
    }
}

