/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.Node;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyLogical
extends PostfixMathCommand
implements CallbackEvaluationI {
    private static final long serialVersionUID = 300L;
    int id;
    public static final int AND = 0;
    public static final int OR = 1;

    public LazyLogical(int n) {
        this.id = n;
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        throw new EvaluationException("Logical: run methods should not have been called");
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        boolean bl;
        boolean bl2;
        Object object = evaluator.eval(node.jjtGetChild(0));
        if (object instanceof Boolean) {
            bl2 = (Boolean)object;
        } else if (object instanceof Number) {
            bl2 = ((Number)object).doubleValue() != 0.0;
        } else {
            throw new EvaluationException("LazyLogical: left hand argument does not evaluate to Boolean");
        }
        switch (this.id) {
            case 0: {
                if (bl2) break;
                return Boolean.FALSE;
            }
            case 1: {
                if (!bl2) break;
                return Boolean.TRUE;
            }
        }
        Object object2 = evaluator.eval(node.jjtGetChild(1));
        if (object2 instanceof Boolean) {
            bl = (Boolean)object2;
        } else if (object instanceof Number) {
            bl = ((Number)object2).doubleValue() != 0.0;
        } else {
            throw new EvaluationException("LazyLogical: right hand argument does not evaluate to Boolean");
        }
        return bl;
    }
}

