/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class If
extends PostfixMathCommand
implements CallbackEvaluationI {
    private static final long serialVersionUID = 300L;

    public If() {
        this.numberOfParameters = -1;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n == 3 || n == 4;
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        double d;
        int n = node.jjtGetNumChildren();
        if (!this.checkNumberOfParameters(n)) {
            throw new EvaluationException("If operator must have 3 or 4 arguments.");
        }
        Object object = evaluator.eval(node.jjtGetChild(0));
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return evaluator.eval(node.jjtGetChild(1));
            }
            return evaluator.eval(node.jjtGetChild(2));
        }
        if (object instanceof Complex) {
            d = ((Complex)object).re();
        } else if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else {
            throw new EvaluationException("Condition in if operator must be Boolean, Number or Complex.");
        }
        if (d > 0.0) {
            return evaluator.eval(node.jjtGetChild(1));
        }
        if (n == 3 || d < 0.0) {
            return evaluator.eval(node.jjtGetChild(2));
        }
        return evaluator.eval(node.jjtGetChild(3));
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        throw new EvaluationException("If: run methods should not have been called");
    }
}

