/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exp
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;

    public Exp() {
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        stack.push(this.exp(object));
    }

    public Object exp(Object object) throws EvaluationException {
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            double d = complex.re();
            double d2 = complex.im();
            double d3 = Math.exp(d);
            return new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
        }
        if (object instanceof Number) {
            return new Double(Math.exp(((Number)object).doubleValue()));
        }
        throw new EvaluationException("Invalid parameter type");
    }
}

