/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.Add;
import com.singularsys.jep.functions.Multiply;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dot
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;
    static Add add = new Add();
    static Multiply mul = new Multiply();

    public Dot() {
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        Object object2 = stack.pop();
        stack.push(this.dot(object2, object));
    }

    public Object dot(Object object, Object object2) throws EvaluationException {
        if (object instanceof Vector && object2 instanceof Vector) {
            return this.dot((Vector)object, (Vector)object2);
        }
        throw new EvaluationException("Dot: Invalid parameter type, both arguments must be vectors");
    }

    public Object dot(Vector vector, Vector vector2) throws EvaluationException {
        if (vector.size() != vector2.size()) {
            throw new EvaluationException("Dot: both sides of dot must be same length");
        }
        int n = vector.size();
        if (n < 1) {
            throw new EvaluationException("Dot: empty vectors parsed");
        }
        Object object = mul.mul(vector.elementAt(0), vector2.elementAt(0));
        for (int i = 1; i < n; ++i) {
            object = add.add(object, mul.mul(vector.elementAt(i), vector2.elementAt(i)));
        }
        return object;
    }
}

