/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.reals.RealBinaryFunction;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Divide
extends PostfixMathCommand
implements RealBinaryFunction {
    private static final long serialVersionUID = 300L;

    public Divide() {
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        Object object2 = stack.pop();
        stack.push(this.div(object2, object));
    }

    public Object div(Object object, Object object2) throws EvaluationException {
        if (object instanceof Complex) {
            if (object2 instanceof Complex) {
                return this.div((Complex)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.div((Complex)object, (Number)object2);
            }
        } else if (object instanceof Number) {
            if (object2 instanceof Complex) {
                return this.div((Number)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.div((Number)object, (Number)object2);
            }
        } else if (object instanceof Vector) {
            return this.div((Vector)object, object2);
        }
        throw new EvaluationException("Invalid parameter type");
    }

    public Double div(Number number, Number number2) {
        return new Double(number.doubleValue() / number2.doubleValue());
    }

    public Complex div(Complex complex, Complex complex2) {
        return complex.div(complex2);
    }

    public Complex div(Number number, Complex complex) {
        Complex complex2 = new Complex(number.doubleValue(), 0.0);
        return complex2.div(complex);
    }

    public Complex div(Complex complex, Number number) {
        return new Complex(complex.re() / number.doubleValue(), complex.im() / number.doubleValue());
    }

    public Vector div(Vector vector, Object object) throws EvaluationException {
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(this.div(vector.elementAt(i), object));
        }
        return vector2;
    }

    @Override
    public double evaluate(double d, double d2) {
        return d / d2;
    }
}

