/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comparative
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;
    protected int id;
    double tolerance;
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int LE = 2;
    public static final int GE = 3;
    public static final int NE = 4;
    public static final int EQ = 5;

    public Comparative(int n) {
        this.id = n;
        this.numberOfParameters = 2;
        this.tolerance = 1.0E-6;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        Object object2 = stack.pop();
        if (this.compare(object2, object)) {
            stack.push(Boolean.TRUE);
        } else {
            stack.push(Boolean.FALSE);
        }
    }

    public boolean compare(Object object, Object object2) throws EvaluationException {
        switch (this.id) {
            case 0: {
                return this.lt(object, object2);
            }
            case 1: {
                return this.gt(object, object2);
            }
            case 2: {
                return this.le(object, object2);
            }
            case 3: {
                return this.ge(object, object2);
            }
            case 4: {
                return this.ne(object, object2);
            }
            case 5: {
                return this.eq(object, object2);
            }
        }
        return false;
    }

    public boolean lt(Object object, Object object2) throws EvaluationException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new EvaluationException("< not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 < (d = ((Number)object2).doubleValue());
        }
        throw new EvaluationException("< not defined for object of type " + object.getClass().getName() + " and " + object2.getClass().getName());
    }

    public boolean gt(Object object, Object object2) throws EvaluationException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new EvaluationException("> not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 > (d = ((Number)object2).doubleValue());
        }
        throw new EvaluationException("> not defined for object of type " + object.getClass().getName() + " and " + object2.getClass().getName());
    }

    public boolean le(Object object, Object object2) throws EvaluationException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new EvaluationException("<= not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 <= (d = ((Number)object2).doubleValue());
        }
        throw new EvaluationException("<= not defined for object of type " + object.getClass().getName() + " and " + object2.getClass().getName());
    }

    public boolean ge(Object object, Object object2) throws EvaluationException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new EvaluationException(">= not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 >= (d = ((Number)object2).doubleValue());
        }
        throw new EvaluationException(">= not defined for object of type " + object.getClass().getName() + " and " + object2.getClass().getName());
    }

    public boolean eq(Object object, Object object2) throws EvaluationException {
        if (object instanceof Complex && object2 instanceof Complex) {
            return ((Complex)object).equals((Complex)object2, this.tolerance);
        }
        if (object instanceof Complex && object2 instanceof Number) {
            return ((Complex)object).equals(new Complex((Number)object2), this.tolerance);
        }
        if (object2 instanceof Complex && object instanceof Number) {
            return ((Complex)object2).equals(new Complex((Number)object), this.tolerance);
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 == (d = ((Number)object2).doubleValue());
        }
        if (object instanceof Boolean && object2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = (Boolean)object;
            return bl2 == (bl = ((Boolean)object2).booleanValue());
        }
        if (object instanceof Number && object2 instanceof Boolean) {
            double d = ((Number)object).doubleValue();
            double d3 = (Boolean)object2 != false ? 1.0 : 0.0;
            return d == d3;
        }
        if (object instanceof Boolean && object2 instanceof Number) {
            double d = (Boolean)object != false ? 1.0 : 0.0;
            double d4 = ((Number)object2).doubleValue();
            return d == d4;
        }
        return object.equals(object2);
    }

    public boolean ne(Object object, Object object2) throws EvaluationException {
        if (object instanceof Complex && object2 instanceof Complex) {
            return !((Complex)object).equals((Complex)object2, this.tolerance);
        }
        if (object instanceof Complex && object2 instanceof Number) {
            return !((Complex)object).equals(new Complex((Number)object2), this.tolerance);
        }
        if (object2 instanceof Complex && object instanceof Number) {
            return !((Complex)object2).equals(new Complex((Number)object), this.tolerance);
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 != (d = ((Number)object2).doubleValue());
        }
        if (object instanceof Boolean && object2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = (Boolean)object;
            return bl2 != (bl = ((Boolean)object2).booleanValue());
        }
        if (object instanceof Number && object2 instanceof Boolean) {
            double d = ((Number)object).doubleValue();
            double d3 = (Boolean)object2 != false ? 1.0 : 0.0;
            return d != d3;
        }
        if (object instanceof Boolean && object2 instanceof Number) {
            double d = (Boolean)object != false ? 1.0 : 0.0;
            double d4 = ((Number)object2).doubleValue();
            return d != d4;
        }
        return !object.equals(object2);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }
}

