/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Binomial
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;
    static final int initN = 20;
    static int[][] coeffs = new int[21][];

    static synchronized void expand(int n) {
        int n2;
        int n3 = coeffs.length - 1;
        if (n <= n3) {
            return;
        }
        int[][] nArrayArray = new int[n + 1][];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArrayArray[n2] = coeffs[n2];
        }
        for (n2 = n3 + 1; n2 <= n; ++n2) {
            nArrayArray[n2] = new int[n2 + 1];
            nArrayArray[n2][0] = 1;
            nArrayArray[n2][n2] = 1;
            for (int i = 1; i < n2; ++i) {
                nArrayArray[n2][i] = nArrayArray[n2 - 1][i - 1] + nArrayArray[n2 - 1][i];
            }
        }
        coeffs = nArrayArray;
    }

    static synchronized int getCoeff(int n, int n2) {
        return coeffs[n2][n];
    }

    public Binomial() {
        Binomial.coeffs[0] = new int[1];
        Binomial.coeffs[0][0] = 1;
        Binomial.coeffs[1] = new int[2];
        Binomial.coeffs[1][0] = 1;
        Binomial.coeffs[1][1] = 1;
        for (int i = 2; i <= 20; ++i) {
            Binomial.coeffs[i] = new int[i + 1];
            Binomial.coeffs[i][0] = 1;
            Binomial.coeffs[i][i] = 1;
            for (int j = 1; j < i; ++j) {
                Binomial.coeffs[i][j] = coeffs[i - 1][j - 1] + coeffs[i - 1][j];
            }
        }
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        Object object = stack.pop();
        Object object2 = stack.pop();
        if (!(object instanceof Number) || !(object2 instanceof Number)) {
            throw new EvaluationException("Binomial: both arguments must be integers. They are " + object2 + "(" + object2.getClass().getName() + ") and " + object + "(" + object2.getClass().getName() + ")");
        }
        int n = ((Number)object).intValue();
        int n2 = ((Number)object2).intValue();
        if (n2 < 0 || n < 0 || n > n2) {
            throw new EvaluationException("Binomial: illegal values for arguments 0<i<n. They are " + object2 + " and " + object);
        }
        Binomial.expand(n2);
        int n3 = Binomial.getCoeff(n, n2);
        stack.push(new Integer(n3));
    }

    public static int binom(int n, int n2) throws ArrayIndexOutOfBoundsException {
        Binomial.expand(n);
        int n3 = Binomial.getCoeff(n2, n);
        return n3;
    }
}

