/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.Add;
import com.singularsys.jep.functions.Divide;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Average
extends PostfixMathCommand
implements RealUnaryFunction {
    private static final long serialVersionUID = 310L;
    static Add add = new Add();
    static Divide div = new Divide();

    public Average() {
        this.numberOfParameters = -1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        Vector vector;
        this.checkStack(stack);
        if (this.curNumberOfParameters < 1) {
            throw new EvaluationException("At least one argument is required");
        }
        if (this.curNumberOfParameters == 1 && stack.peek() instanceof Vector) {
            vector = (Vector)stack.pop();
        } else {
            vector = new Vector(this.curNumberOfParameters);
            for (int i = 0; i < this.curNumberOfParameters; ++i) {
                vector.add(stack.pop());
            }
        }
        if (vector.size() == 0) {
            this.throwAtLeastOneExcep();
        }
        stack.push(this.average(vector));
    }

    private void throwAtLeastOneExcep() throws EvaluationException {
        throw new EvaluationException("At least one argument is required");
    }

    public Object average(Object object) throws EvaluationException {
        if (object instanceof Complex) {
            return object;
        }
        if (object instanceof Number) {
            return object;
        }
        if (object instanceof Vector) {
            return this.average((Vector)object);
        }
        throw new EvaluationException("Invalid parameter type");
    }

    public Object average(Vector vector) throws EvaluationException {
        Object object = null;
        for (int i = 0; i < vector.size(); ++i) {
            object = i == 0 ? (Object)vector.elementAt(i) : add.add(object, vector.elementAt(i));
        }
        if (object == null) {
            throw new EvaluationException("Can not calculate average of empty array");
        }
        return div.div(object, (Object)vector.size());
    }

    @Override
    public double evaluate(double d) {
        return d;
    }
}

