/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.LValueI;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assign
extends PostfixMathCommand
implements CallbackEvaluationI {
    private static final long serialVersionUID = 300L;

    public Assign() {
        this.numberOfParameters = 2;
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        if (node.jjtGetNumChildren() != 2) {
            throw new EvaluationException("Assignment operator must have 2 operators.");
        }
        Object object = evaluator.eval(node.jjtGetChild(1));
        Node node2 = node.jjtGetChild(0);
        if (node2 instanceof ASTVarNode) {
            ASTVarNode aSTVarNode = (ASTVarNode)node2;
            Variable variable = aSTVarNode.getVar();
            variable.setValue(object);
            return object;
        }
        if (node2 instanceof ASTFunNode && ((ASTFunNode)node2).getPFMC() instanceof LValueI) {
            ((LValueI)((Object)((ASTFunNode)node2).getPFMC())).set(evaluator, node2, object);
            return object;
        }
        throw new EvaluationException("Assignment should have a variable or LValue for the lhs.");
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        throw new EvaluationException("Assign: run methods should not have been called");
    }
}

