/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcCosineH
extends PostfixMathCommand
implements RealUnaryFunction {
    private static final long serialVersionUID = 300L;

    public ArcCosineH() {
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        stack.push(this.acosh(object));
    }

    public Object acosh(Object object) throws EvaluationException {
        if (object instanceof Complex) {
            return ((Complex)object).acosh();
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d >= 1.0) {
                double d2 = Math.log(d + Math.sqrt(d * d - 1.0));
                return new Double(d2);
            }
            Complex complex = new Complex(((Number)object).doubleValue(), 0.0);
            return complex.acosh();
        }
        throw new EvaluationException("Invalid parameter type");
    }

    @Override
    public double evaluate(double d) {
        if (d >= 1.0) {
            return Math.log(d + Math.sqrt(d * d - 1.0));
        }
        return Double.NaN;
    }
}

