/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.reals.RealBinaryFunction;
import com.singularsys.jep.standard.Complex;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Add
extends PostfixMathCommand
implements RealBinaryFunction {
    private static final long serialVersionUID = 300L;

    public Add() {
        this.numberOfParameters = -1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        for (int i = 1; i < this.curNumberOfParameters; ++i) {
            Object object2 = stack.pop();
            object = this.add(object2, object);
        }
        stack.push(object);
    }

    public Object add(Object object, Object object2) throws EvaluationException {
        if (object instanceof Complex) {
            if (object2 instanceof Complex) {
                return this.add((Complex)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.add((Complex)object, (Number)object2);
            }
        } else if (object instanceof Number) {
            if (object2 instanceof Complex) {
                return this.add((Complex)object2, (Number)object);
            }
            if (object2 instanceof Number) {
                return this.add((Number)object, (Number)object2);
            }
        } else {
            if (object instanceof String && object2 instanceof String) {
                return (String)object + (String)object2;
            }
            if (object instanceof Vector && object2 instanceof Vector) {
                return this.add((Vector)object, (Vector)object2);
            }
        }
        throw new EvaluationException("Invalid parameter type");
    }

    public Double add(Number number, Number number2) {
        return new Double(number.doubleValue() + number2.doubleValue());
    }

    public Complex add(Complex complex, Complex complex2) {
        return new Complex(complex.re() + complex2.re(), complex.im() + complex2.im());
    }

    public Vector add(Vector vector, Vector vector2) throws EvaluationException {
        if (vector.size() != vector2.size()) {
            throw new EvaluationException("Add: dimensions of vectors do not match, " + vector.size() + ", " + vector2.size());
        }
        Vector<Object> vector3 = new Vector<Object>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            vector3.add(i, this.add(vector.get(i), vector2.get(i)));
        }
        return vector3;
    }

    public Complex add(Complex complex, Number number) {
        return new Complex(complex.re() + number.doubleValue(), complex.im());
    }

    @Override
    public double evaluate(double d, double d2) {
        return d + d2;
    }
}

