/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser.tokens;

import com.singularsys.jep.Operator;
import com.singularsys.jep.configurableparser.tokens.Token;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorToken
extends Token {
    private static final long serialVersionUID = 300L;
    Operator binaryOp = null;
    Operator prefixOp = null;
    Operator suffixOp = null;
    Operator ternaryOp = null;

    public OperatorToken(List<Operator> list) {
        super(list.get(0).getSymbol());
        for (Operator operator : list) {
            this.setOp(operator);
        }
    }

    public OperatorToken(Operator[] operatorArray) {
        super(operatorArray[0].getSymbol());
        for (Operator operator : operatorArray) {
            this.setOp(operator);
        }
    }

    public OperatorToken(Operator operator) {
        super(operator.getSymbol());
        this.setOp(operator);
    }

    private void setOp(Operator operator) {
        if (operator.isBinary()) {
            this.binaryOp = operator;
        } else if (operator.isPrefix()) {
            this.prefixOp = operator;
        } else if (operator.isSuffix()) {
            this.suffixOp = operator;
        } else if (operator.isTernary()) {
            this.ternaryOp = operator;
        }
    }

    public Operator getBinaryOp() {
        return this.binaryOp;
    }

    public Operator getPrefixOp() {
        return this.prefixOp;
    }

    public Operator getSuffixOp() {
        return this.suffixOp;
    }

    public Operator getTernaryOp() {
        return this.ternaryOp;
    }

    @Override
    public boolean isOperator() {
        return true;
    }

    @Override
    public boolean isBinary() {
        return this.binaryOp != null;
    }

    @Override
    public boolean isPrefix() {
        return this.prefixOp != null;
    }

    @Override
    public boolean isSuffix() {
        return this.suffixOp != null;
    }

    @Override
    public boolean isTernary() {
        return this.ternaryOp != null;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (");
        boolean bl = false;
        if (this.isBinary()) {
            stringBuffer.append(this.binaryOp.getName());
            bl = true;
        }
        if (this.isPrefix()) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.prefixOp.getName() + ',');
            bl = true;
        }
        if (this.isSuffix()) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.suffixOp.getName() + ',');
            bl = true;
        }
        if (this.isTernary()) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.ternaryOp.getName() + ',');
            bl = true;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

