/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser.matchers;

import com.singularsys.jep.Jep;
import com.singularsys.jep.configurableparser.matchers.RegExpTokenMatcher;
import com.singularsys.jep.configurableparser.tokens.StringToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTokenMatcher
extends RegExpTokenMatcher {
    private static final long serialVersionUID = 300L;
    private char delim;

    public StringTokenMatcher(Pattern pattern, char c) {
        super(pattern);
        this.delim = c;
    }

    public StringTokenMatcher(String string) {
        super(string);
    }

    public Token match(String string) {
        Matcher matcher = this.pattern.matcher(string);
        if (matcher.lookingAt()) {
            String string2 = matcher.group(1);
            String string3 = string2.replace("\\\"", "\"");
            return this.buildToken(matcher.group(), string3);
        }
        return null;
    }

    private Token buildToken(String string, String string2) {
        return new StringToken(string, string2, this.delim);
    }

    public static StringTokenMatcher doubleQuoteStringMatcher() {
        return new StringTokenMatcher(Pattern.compile("\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\""), '\"');
    }

    public static StringTokenMatcher singleQuoteStringMatcher() {
        return new StringTokenMatcher(Pattern.compile("'((\\'|[^'])*)'"), '\'');
    }

    public Token buildToken(String string) {
        throw new UnsupportedOperationException("Attempt to call buildToken.");
    }

    public void init(Jep jep) {
    }
}

