/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser.matchers;

import com.singularsys.jep.Jep;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTable;
import com.singularsys.jep.configurableparser.TernaryOperator;
import com.singularsys.jep.configurableparser.matchers.TokenMatcher;
import com.singularsys.jep.configurableparser.tokens.OperatorToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class OperatorTokenMatcher
implements TokenMatcher {
    private static final long serialVersionUID = 300L;
    private transient SortedMap<String, List<Operator>> map;
    private transient SortedMap<String, Token> tokens;

    public void init(Jep jep) {
        this.init(jep.getOperatorTable());
    }

    public void init(OperatorTable operatorTable) {
        OTMComp oTMComp = new OTMComp();
        this.map = new TreeMap<String, List<Operator>>(oTMComp);
        for (Operator object : operatorTable.getOperators()) {
            String string = object.getSymbol();
            Operator operator = object;
            if (operator.notInParser()) continue;
            List<Operator> list = (ArrayList<Operator>)this.map.get(string);
            if (list == null) {
                list = new ArrayList<Operator>();
            }
            list.add(operator);
            this.map.put(string, list);
            if (!operator.isTernary()) continue;
            String string2 = ((TernaryOperator)object).getRhsSymbol();
            if (operator.notInParser()) continue;
            list = (List)this.map.get(string2);
            if (list == null) {
                list = new ArrayList();
            }
            list.add(operator);
            this.map.put(string, list);
        }
        this.tokens = new TreeMap<String, Token>(oTMComp);
        for (String string : this.map.keySet()) {
            this.tokens.put(string, new OperatorToken((List)this.map.get(string)));
        }
    }

    public Token match(String string) {
        for (String string2 : this.tokens.keySet()) {
            if (!string.startsWith(string2)) continue;
            return (Token)this.tokens.get(string2);
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.map.keySet()) {
            stringBuffer.append(string + ",");
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OTMComp
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 300L;

        OTMComp() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = string2.length() - string.length();
            if (n == 0) {
                return string.compareTo(string2);
            }
            return n;
        }
    }
}

