/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser;

import com.singularsys.jep.ParseException;
import com.singularsys.jep.configurableparser.matchers.TokenMatcher;
import com.singularsys.jep.configurableparser.tokens.MultiLineToken;
import com.singularsys.jep.configurableparser.tokens.TerminatorToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import com.singularsys.jep.configurableparser.tokens.WhiteSpaceToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tokenizer {
    protected List<TokenMatcher> matchers;
    protected int currentPos = 0;
    protected String currentLine = null;
    protected BufferedReader br;
    protected List<Token> tokens;

    public Tokenizer(BufferedReader bufferedReader, List<TokenMatcher> list) {
        this.br = bufferedReader;
        this.matchers = list;
        this.tokens = new ArrayList<Token>();
    }

    public List<Token> scan() throws ParseException {
        Token token;
        this.tokens.clear();
        while ((token = this.nextToken()) != null && !(token instanceof TerminatorToken)) {
            if (token instanceof MultiLineToken) {
                token = this.readMultiLine((MultiLineToken)token);
            }
            this.tokens.add(token);
        }
        return this.tokens;
    }

    private Token nextToken() throws ParseException {
        if (this.currentLine == null) {
            try {
                this.currentLine = this.br.readLine();
            }
            catch (IOException iOException) {
                throw new ParseException(iOException.getClass().getSimpleName() + iOException.getMessage());
            }
            if (this.currentLine == null) {
                return null;
            }
            this.currentPos = 0;
        } else if (this.currentPos >= this.currentLine.length()) {
            try {
                this.currentLine = this.br.readLine();
            }
            catch (IOException iOException) {
                throw new ParseException(iOException.getClass().getSimpleName() + iOException.getMessage());
            }
            if (this.currentLine == null) {
                return null;
            }
            this.currentPos = 0;
            return new WhiteSpaceToken("\n");
        }
        String string = this.currentPos == 0 ? this.currentLine : this.currentLine.substring(this.currentPos);
        Token token = this.nextToken(string);
        if (token == null) {
            throw new ParseException("Could not match text '" + string + "'.");
        }
        return token;
    }

    private Token nextToken(String string) {
        for (TokenMatcher tokenMatcher : this.matchers) {
            Token token = tokenMatcher.match(string);
            if (token == null) continue;
            this.currentPos += token.getLength();
            return token;
        }
        return null;
    }

    private Token readMultiLine(MultiLineToken multiLineToken) throws ParseException {
        Token token;
        do {
            try {
                this.currentLine = this.br.readLine();
            }
            catch (IOException iOException) {
                throw new ParseException(iOException.getClass().getSimpleName() + iOException.getMessage());
            }
            if (this.currentLine != null) continue;
            throw new ParseException("Comment not closed");
        } while ((token = multiLineToken.match(this.currentLine)) == null);
        this.currentPos = token.getLength();
        return multiLineToken.getCompleteToken();
    }

    public static String toString(List<Token> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token : list) {
            stringBuilder.append(token.toString());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

