/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.configurableparser.GrammarParser;
import com.singularsys.jep.configurableparser.Lookahead2Iterator;
import com.singularsys.jep.configurableparser.matchers.GrammarMatcher;
import com.singularsys.jep.configurableparser.tokens.NumberToken;
import com.singularsys.jep.configurableparser.tokens.OperatorToken;
import com.singularsys.jep.configurableparser.tokens.StringToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.Node;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShuntingYard
implements GrammarParser {
    protected static final boolean DUMP = false;
    protected Stack<Operator> ops = new Stack();
    protected Stack<Node> nodes = new Stack();
    protected Lookahead2Iterator<Token> it;
    protected List<GrammarMatcher> matchers;
    protected Jep jep;
    protected static Operator sentinel = new Operator("Sentinel", null, 0);

    ShuntingYard(Jep jep, List<GrammarMatcher> list) {
        this.jep = jep;
        this.matchers = list;
    }

    public Node parse(Iterator<Token> iterator) throws ParseException {
        if (!iterator.hasNext()) {
            return null;
        }
        this.it = new Lookahead2Iterator<Token>(iterator);
        Node node = this.parseSubExpression();
        if (this.it.peekNext() != null) {
            throw new ParseException("Tokens still remaining after parse completed");
        }
        if (!this.nodes.empty()) {
            throw new ParseException("Only one node should be of stack after parsing, it has " + this.nodes.size());
        }
        return node;
    }

    @Override
    public Node parseSubExpression() throws ParseException {
        this.ops.push(sentinel);
        try {
            this.E();
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (JepException jepException) {
            throw new ParseException(jepException);
        }
        if (!sentinel.equals(this.ops.pop())) {
            throw new ParseException("Top of stack should be a sentinel");
        }
        return this.nodes.pop();
    }

    void E() throws JepException {
        this.PS();
        Token token = this.it.peekNext();
        while (token != null) {
            if (token.isBinary()) {
                this.pushOp(((OperatorToken)this.it.peekNext()).getBinaryOp());
                this.it.consume();
                this.PS();
            } else if (token.isTernary()) {
                this.pushOp(((OperatorToken)this.it.peekNext()).getTernaryOp());
                this.it.consume();
                this.PS();
                this.it.consume();
                this.PS();
            } else {
                if (!token.isImplicitMulRhs()) break;
                if (!this.jep.getImplicitMul()) {
                    throw new ParseException("Implicit multiplication not enabled");
                }
                this.PS();
                Node node = this.nodes.pop();
                Node node2 = this.nodes.pop();
                ASTOpNode aSTOpNode = this.jep.getNodeFactory().buildOperatorNode(this.jep.getOperatorTable().getOperator(5), node2, node);
                this.nodes.push(aSTOpNode);
            }
            token = this.it.peekNext();
        }
        while (!sentinel.equals(this.ops.peek())) {
            this.popOp();
        }
    }

    void PS() throws JepException {
        Token token;
        this.P();
        while ((token = this.it.peekNext()) != null && token.isSuffix()) {
            this.pushOp(((OperatorToken)token).getSuffixOp());
            this.it.consume();
        }
    }

    void P() throws JepException {
        for (GrammarMatcher grammarMatcher : this.matchers) {
            Node node = grammarMatcher.match(this.it, this);
            if (node == null) continue;
            this.nodes.push(node);
            return;
        }
        Token token = this.it.peekNext();
        if (token == null) {
            throw new ParseException("Unexpected end of input");
        }
        if (token.isIdentifier()) {
            this.it.consume();
            this.nodes.push(this.jep.getNodeFactory().buildVariableNodeCheckUndeclared(token.getSource()));
        } else if (token.isNumber()) {
            this.it.consume();
            this.nodes.push(this.jep.getNodeFactory().buildConstantNode(((NumberToken)token).getValue()));
        } else if (token.isString()) {
            this.it.consume();
            this.nodes.push(this.jep.getNodeFactory().buildConstantNode(((StringToken)token).getUnquotedString()));
        } else if (token.isPrefix()) {
            this.pushOp(((OperatorToken)token).getPrefixOp());
            this.it.consume();
            this.PS();
        } else {
            throw new ParseException("Unexpected token " + token.toString());
        }
    }

    void pushOp(Operator operator) throws JepException {
        while (this.compareOps(this.ops.peek(), operator)) {
            this.popOp();
        }
        this.ops.push(operator);
    }

    void popOp() throws JepException {
        Operator operator = this.ops.pop();
        if (operator.isBinary()) {
            Node node = this.nodes.pop();
            Node node2 = this.nodes.pop();
            ASTOpNode aSTOpNode = this.jep.getNodeFactory().buildOperatorNode(operator, node2, node);
            this.nodes.push(aSTOpNode);
        } else if (operator.isUnary()) {
            Node node = this.nodes.pop();
            ASTOpNode aSTOpNode = this.jep.getNodeFactory().buildOperatorNode(operator, node);
            this.nodes.push(aSTOpNode);
        } else {
            throw new ParseException("Node on stack should be unary or binary");
        }
    }

    boolean compareOps(Operator operator, Operator operator2) {
        if (operator == sentinel) {
            return false;
        }
        if (operator2 == sentinel) {
            return true;
        }
        if (operator.getPrecedence() < operator2.getPrecedence()) {
            return true;
        }
        return operator.getPrecedence() == operator2.getPrecedence() && operator.isLeftBinding();
    }

    protected void dumpState(String string) {
        System.out.println(string + "\t" + this.it.peekNext() + "\t" + this.it.nextnext());
        System.out.println("Nodes: " + this.nodes.toString());
        System.out.print("Ops: [");
        for (Operator operator : this.ops) {
            System.out.print(operator.getName() + " ");
        }
        System.out.print("]\n\n");
    }
}

