/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Parser;
import com.singularsys.jep.configurableparser.ShuntingYard;
import com.singularsys.jep.configurableparser.TokenFilter;
import com.singularsys.jep.configurableparser.Tokenizer;
import com.singularsys.jep.configurableparser.WhiteSpaceCommentFilter;
import com.singularsys.jep.configurableparser.matchers.ArrayAccessGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.CommentTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.FunctionGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.GrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.IdentifierTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.ListGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.NumberTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.OperatorTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.RoundBracketGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.StringTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.SymbolTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.TerminatorTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.TokenMatcher;
import com.singularsys.jep.configurableparser.matchers.WhiteSpaceTokenMatcher;
import com.singularsys.jep.configurableparser.tokens.SymbolToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import com.singularsys.jep.parser.Node;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableParser
implements Parser {
    private static final long serialVersionUID = 300L;
    protected List<TokenMatcher> m;
    protected List<TokenFilter> filters;
    protected List<GrammarMatcher> gm;
    protected transient Tokenizer tk;
    protected transient Jep jep;

    public ConfigurableParser() {
        this.m = new ArrayList<TokenMatcher>();
        this.filters = new ArrayList<TokenFilter>();
        this.gm = new ArrayList<GrammarMatcher>();
        this.m.add(CommentTokenMatcher.hashCommentMatcher());
        this.m.add(CommentTokenMatcher.slashSlashCommentMatcher());
        this.m.add(CommentTokenMatcher.slashStarCommentMatcher());
        this.m.add(CommentTokenMatcher.multiLineSlashStarCommentMatcher());
        this.m.add(StringTokenMatcher.doubleQuoteStringMatcher());
        this.m.add(WhiteSpaceTokenMatcher.defaultWhiteSpaceTokenMatcher());
        this.m.add(NumberTokenMatcher.exponentNumberTokenMatcher());
        OperatorTokenMatcher operatorTokenMatcher = new OperatorTokenMatcher();
        this.m.add(operatorTokenMatcher);
        SymbolToken symbolToken = new SymbolToken("(", true);
        SymbolToken symbolToken2 = new SymbolToken(")");
        SymbolToken symbolToken3 = new SymbolToken("[", true);
        SymbolToken symbolToken4 = new SymbolToken("]");
        SymbolToken symbolToken5 = new SymbolToken(",");
        SymbolTokenMatcher symbolTokenMatcher = new SymbolTokenMatcher();
        symbolTokenMatcher.add(symbolToken);
        symbolTokenMatcher.add(symbolToken2);
        symbolTokenMatcher.add(symbolToken3);
        symbolTokenMatcher.add(symbolToken4);
        symbolTokenMatcher.add(symbolToken5);
        this.m.add(symbolTokenMatcher);
        this.m.add(IdentifierTokenMatcher.basicIndetifierMatcher());
        TerminatorTokenMatcher terminatorTokenMatcher = TerminatorTokenMatcher.SemiColonTerminalMatcher();
        this.m.add(terminatorTokenMatcher);
        this.filters.add(new WhiteSpaceCommentFilter());
        this.gm.add(new RoundBracketGrammarMatcher(symbolToken, symbolToken2));
        this.gm.add(new FunctionGrammarMatcher(symbolToken, symbolToken2, symbolToken5));
        this.gm.add(new ListGrammarMatcher(symbolToken3, symbolToken4, symbolToken5));
        this.gm.add(new ArrayAccessGrammarMatcher(symbolToken3, symbolToken4));
    }

    protected ConfigurableParser(boolean bl) {
        this.m = new ArrayList<TokenMatcher>();
        this.filters = new ArrayList<TokenFilter>();
        this.gm = new ArrayList<GrammarMatcher>();
    }

    public ConfigurableParser(List<TokenMatcher> list, List<TokenFilter> list2, List<GrammarMatcher> list3) {
        this.m = list;
        this.filters = list2;
        this.gm = list3;
    }

    @Override
    public void init(Jep jep) {
        this.jep = jep;
        for (TokenMatcher object : this.m) {
            object.init(jep);
        }
        for (TokenFilter tokenFilter : this.filters) {
            tokenFilter.init(jep);
        }
        for (GrammarMatcher grammarMatcher : this.gm) {
            grammarMatcher.init(jep);
        }
    }

    @Override
    public Node parse(Reader reader) throws ParseException {
        List<Token> list = this.scan(reader);
        Iterator<Token> iterator = this.filter(list);
        Node node = this.parse(iterator);
        return node;
    }

    @Override
    public void restart(Reader reader) {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.tk = new Tokenizer(bufferedReader, this.m);
    }

    @Override
    public Node continueParse() throws ParseException {
        List<Token> list = this.scan();
        Iterator<Token> iterator = this.filter(list);
        Node node = this.parse(iterator);
        return node;
    }

    public List<Token> scan(Reader reader) throws ParseException {
        this.restart(reader);
        List<Token> list = this.scan();
        return list;
    }

    public List<Token> scan() throws ParseException {
        List<Token> list = this.tk.scan();
        return list;
    }

    public Iterator<Token> filter(List<Token> list) throws ParseException {
        Iterator<Token> iterator = list.iterator();
        for (TokenFilter tokenFilter : this.filters) {
            iterator = tokenFilter.filter(iterator);
        }
        return iterator;
    }

    public Node parse(Iterator<Token> iterator) throws ParseException {
        ShuntingYard shuntingYard = new ShuntingYard(this.jep, this.gm);
        Node node = shuntingYard.parse(iterator);
        return node;
    }

    public List<GrammarMatcher> getGrammarMatchers() {
        return this.gm;
    }

    public List<TokenMatcher> getTokenMatchers() {
        return this.m;
    }

    public List<TokenFilter> getTokenFilters() {
        return this.filters;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }
}

