/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.math.BigDecimal;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecRelational
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;
    protected int id;
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int LE = 2;
    public static final int GE = 3;
    public static final int NE = 4;
    public static final int EQ = 5;

    public BigDecRelational(int n) {
        this.id = n;
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        this.checkStack(stack);
        Object object = stack.pop();
        Object object2 = stack.pop();
        boolean bl = false;
        if (object2 instanceof BigDecimal && object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object2;
            BigDecimal bigDecimal2 = (BigDecimal)object;
            switch (this.id) {
                case 0: {
                    bl = bigDecimal.compareTo(bigDecimal2) < 0;
                    break;
                }
                case 1: {
                    bl = bigDecimal.compareTo(bigDecimal2) > 0;
                    break;
                }
                case 2: {
                    bl = bigDecimal.compareTo(bigDecimal2) <= 0;
                    break;
                }
                case 3: {
                    bl = bigDecimal.compareTo(bigDecimal2) >= 0;
                    break;
                }
                case 4: {
                    bl = bigDecimal.compareTo(bigDecimal2) != 0;
                    break;
                }
                case 5: {
                    bl = bigDecimal.compareTo(bigDecimal2) == 0;
                }
            }
        } else {
            throw new EvaluationException("< not defined for object of type " + object2.getClass().getName() + " and " + object.getClass().getName());
        }
        stack.push(bl ? Boolean.TRUE : Boolean.FALSE);
    }
}

