/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecPow
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;
    MathContext mc;

    public BigDecPow(MathContext mathContext) {
        this.mc = mathContext;
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        Object object = stack.pop();
        Object object2 = stack.pop();
        if (!(object instanceof BigDecimal)) {
            throw new EvaluationException("Argument should be a big decimal");
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        if (!(object2 instanceof BigDecimal)) {
            throw new EvaluationException("Argument should be a big decimal");
        }
        BigDecimal bigDecimal2 = (BigDecimal)object2;
        BigDecimal bigDecimal3 = this.mc != null ? bigDecimal2.pow(bigDecimal.intValueExact(), this.mc) : bigDecimal2.pow(bigDecimal.intValueExact());
        stack.push(bigDecimal3);
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
    }
}

