/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecNegate
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;
    MathContext mc;

    public BigDecNegate(MathContext mathContext) {
        this.mc = mathContext;
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        Object object = stack.pop();
        if (!(object instanceof BigDecimal)) {
            throw new EvaluationException("Argument should be a big decimal");
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        BigDecimal bigDecimal2 = this.mc != null ? bigDecimal.negate(this.mc) : bigDecimal.negate();
        stack.push(bigDecimal2);
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
    }
}

