/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecAdd
extends PostfixMathCommand {
    private static final long serialVersionUID = 300L;
    MathContext mc;

    public BigDecAdd(MathContext mathContext) {
        this.mc = mathContext;
        this.numberOfParameters = -1;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        Object object = stack.pop();
        if (!(object instanceof BigDecimal)) {
            throw new EvaluationException("Argument should be a big decimal");
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        for (int i = 1; i < this.curNumberOfParameters; ++i) {
            Object object2 = stack.pop();
            if (!(object2 instanceof BigDecimal)) {
                throw new EvaluationException("Argument should be a big decimal");
            }
            BigDecimal bigDecimal2 = (BigDecimal)object2;
            bigDecimal = this.mc != null ? bigDecimal2.add(bigDecimal, this.mc) : bigDecimal2.add(bigDecimal);
        }
        stack.push(bigDecimal);
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
    }
}

