/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal;

import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTable;
import com.singularsys.jep.bigdecimal.functions.BigDecAdd;
import com.singularsys.jep.bigdecimal.functions.BigDecDiv;
import com.singularsys.jep.bigdecimal.functions.BigDecMod;
import com.singularsys.jep.bigdecimal.functions.BigDecMul;
import com.singularsys.jep.bigdecimal.functions.BigDecNegate;
import com.singularsys.jep.bigdecimal.functions.BigDecPow;
import com.singularsys.jep.bigdecimal.functions.BigDecRelational;
import com.singularsys.jep.bigdecimal.functions.BigDecSub;
import com.singularsys.jep.functions.Assign;
import com.singularsys.jep.functions.Logical;
import com.singularsys.jep.functions.Not;
import java.math.MathContext;

public class BigDecOperatorTable
extends OperatorTable {
    private static final long serialVersionUID = 300L;
    MathContext mc;
    BigDecAdd BD_ADD;
    BigDecSub BD_SUB;
    BigDecNegate BD_NEG;
    BigDecMul BD_MUL;
    BigDecDiv BD_DIV;
    BigDecMod BD_MOD;
    BigDecPow BD_POW;

    public BigDecOperatorTable(MathContext mathContext) {
        this.mc = mathContext;
        this.BD_ADD = new BigDecAdd(mathContext);
        this.BD_SUB = new BigDecSub(mathContext);
        this.BD_NEG = new BigDecNegate(mathContext);
        this.BD_MUL = new BigDecMul(mathContext);
        this.BD_DIV = new BigDecDiv(mathContext);
        this.BD_MOD = new BigDecMod(mathContext);
        this.BD_POW = new BigDecPow(mathContext);
        this.addOperator(1, new Operator("+", this.BD_ADD, 54));
        this.addOperator(2, new Operator("-", this.BD_SUB, 12294));
        this.addOperator(3, new Operator("UMinus", "-", this.BD_NEG, 2569));
        this.addOperator(4, new Operator("UPlus", "+", this.BD_ADD, 521));
        this.addOperator(5, new Operator("*", this.BD_MUL, 54));
        this.addOperator(6, new Operator("/", this.BD_DIV, 4102));
        this.addOperator(7, new Operator("%", this.BD_MOD, 6));
        this.addOperator(8, new Operator("UDivide", "^-1", null, 18953));
        this.addOperator(9, new Operator("^", this.BD_POW, 10));
        this.addOperator(10, new Operator(">", new BigDecRelational(1), 262));
        this.addOperator(11, new Operator("<", new BigDecRelational(0), 262));
        this.addOperator(13, new Operator("<=", new BigDecRelational(2), 326));
        this.addOperator(14, new Operator(">=", new BigDecRelational(3), 326));
        this.addOperator(12, new Operator("==", new BigDecRelational(5), 454));
        this.addOperator(15, new Operator("!=", new BigDecRelational(4), 134));
        this.addOperator(16, new Operator("&&", new Logical(0), 8246));
        this.addOperator(17, new Operator("||", new Logical(1), 54));
        this.addOperator(18, new Operator("!", new Not(), 2569));
        this.addOperator(19, new Operator("=", new Assign(), 10));
        this.setPrecedenceTable(new int[][]{{3, 4, 18}, {9}, {5, 6, 7}, {1, 2}, {11, 13}, {10, 14}, {12}, {15}, {16}, {17}, {19}});
        this.setStandardOperatorRelations();
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
        this.BD_ADD.setMathContext(mathContext);
        this.BD_SUB.setMathContext(mathContext);
        this.BD_MUL.setMathContext(mathContext);
        this.BD_DIV.setMathContext(mathContext);
        this.BD_MOD.setMathContext(mathContext);
        this.BD_POW.setMathContext(mathContext);
        this.BD_NEG.setMathContext(mathContext);
    }
}

