/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.standard.Complex;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class BigDecNumberFactory
implements NumberFactory {
    private static final long serialVersionUID = 300L;
    public static final BigDecimal TWO = new BigDecimal("2");
    public static final BigDecimal MINUSONE = new BigDecimal("-1");
    protected MathContext mc = null;

    public BigDecNumberFactory(MathContext mathContext) {
        this.mc = mathContext;
    }

    public Object createNumber(String string) throws ParseException {
        if (this.mc != null) {
            return new BigDecimal(string, this.mc);
        }
        return new BigDecimal(string);
    }

    public Object createNumber(double d) throws ParseException {
        if (this.mc != null) {
            return new BigDecimal(d, this.mc);
        }
        return BigDecimal.valueOf(d);
    }

    public Object createNumber(int n) throws ParseException {
        if (this.mc != null) {
            return new BigDecimal(n, this.mc);
        }
        return BigDecimal.valueOf(n);
    }

    public Object createNumber(short s) throws ParseException {
        if (this.mc != null) {
            return new BigDecimal(s, this.mc);
        }
        return BigDecimal.valueOf(s);
    }

    public Object createNumber(long l) throws ParseException {
        if (this.mc != null) {
            return new BigDecimal(l, this.mc);
        }
        return BigDecimal.valueOf(l);
    }

    public Object createNumber(float f) throws ParseException {
        if (this.mc != null) {
            return new BigDecimal(f, this.mc);
        }
        return BigDecimal.valueOf(f);
    }

    public Object createNumber(boolean bl) throws ParseException {
        if (bl) {
            return BigDecimal.ONE;
        }
        return BigDecimal.ZERO;
    }

    public Object createNumber(Number number) throws ParseException {
        if (number instanceof BigDecimal) {
            return number;
        }
        if (number instanceof Double || number instanceof Float) {
            if (this.mc != null) {
                return new BigDecimal(number.doubleValue(), this.mc);
            }
            return BigDecimal.valueOf(number.doubleValue());
        }
        if (number instanceof Integer || number instanceof Short || number instanceof Long) {
            if (this.mc != null) {
                return new BigDecimal(number.longValue(), this.mc);
            }
            return BigDecimal.valueOf(number.longValue());
        }
        if (number instanceof BigInteger) {
            if (this.mc != null) {
                return new BigDecimal((BigInteger)number, this.mc);
            }
            return new BigDecimal((BigInteger)number);
        }
        return null;
    }

    public Object createNumber(Complex complex) throws ParseException {
        return null;
    }

    public Object getMinusOne() {
        return MINUSONE;
    }

    public Object getZero() {
        return BigDecimal.ZERO;
    }

    public Object getOne() {
        return BigDecimal.ONE;
    }

    public Object getTwo() {
        return TWO;
    }

    public void init(Jep jep) {
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
    }

    public JepComponent getLightWeightInstance() {
        return this;
    }
}

