/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.Variable;
import com.singularsys.jep.VariableFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableTable
extends Observable
implements JepComponent {
    private static final long serialVersionUID = 300L;
    protected Map<String, Variable> table = new HashMap<String, Variable>();
    protected transient VariableFactory vf;

    @Override
    public void init(Jep jep) {
        this.vf = jep.getVariableFactory();
    }

    public Variable addVariable(String string) {
        Variable variable = this.table.get(string);
        if (variable == null) {
            variable = this.vf.createVariable(string);
            this.table.put(string, variable);
            this.setChanged();
            this.notifyObservers();
        }
        return variable;
    }

    public Variable addVariable(String string, Object object) {
        return this.addVariable(string, object, this.vf);
    }

    public Variable addVariable(String string, Object object, VariableFactory variableFactory) {
        Variable variable = this.table.get(string);
        if (variable == null) {
            variable = variableFactory.createVariable(string, object);
            this.table.put(string, variable);
            this.setChanged();
            this.notifyObservers();
        } else {
            variable.setValue(object);
        }
        return variable;
    }

    public Variable getVariable(String string) {
        return this.table.get(string);
    }

    public void clear() {
        this.table.clear();
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public Set<String> keySet() {
        return this.table.keySet();
    }

    public Collection<Variable> getVariables() {
        return this.table.values();
    }

    public Variable remove(String string) {
        Variable variable = this.table.remove(string);
        this.setChanged();
        this.notifyObservers();
        return variable;
    }

    public Variable remove(Variable variable) {
        return this.remove(variable.getName());
    }

    @Deprecated
    public Collection<Variable> values() {
        return this.table.values();
    }

    public int size() {
        return this.table.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n = 0;
        for (Variable variable : this.getVariables()) {
            if (n++ > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(variable);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new VariableTable();
    }

    public JepComponent newInstance() {
        JepComponent jepComponent = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            jepComponent = (JepComponent)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return jepComponent;
    }
}

