/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParserVisitor;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;

public class PrintVisitor
implements ParserVisitor,
JepComponent {
    private static final long serialVersionUID = 300L;
    public static final int FULL_BRACKET = 1;
    public static final int COMPLEX_I = 2;
    private int maxLen = -1;
    protected transient StringBuffer sb;
    protected int mode = 0;
    private Map<Operator, PrintRulesI> specialRules = new HashMap<Operator, PrintRulesI>();
    protected NumberFormat format;
    private transient FieldPosition fp = new FieldPosition(1);

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fp = new FieldPosition(1);
    }

    public void init(Jep jep) {
        Operator operator = jep.getOperatorTable().getOperator(22);
        Operator operator2 = jep.getOperatorTable().getOperator(23);
        if (!this.specialRules.containsKey(operator)) {
            this.specialRules.put(operator, new PrintRulesI(){
                private static final long serialVersionUID = 300L;

                public void append(Node node, PrintVisitor printVisitor) throws JepException {
                    printVisitor.append("[");
                    for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                        if (i > 0) {
                            printVisitor.append(",");
                        }
                        node.jjtGetChild(i).jjtAccept(printVisitor, null);
                    }
                    printVisitor.append("]");
                }
            });
        }
        if (!this.specialRules.containsKey(operator2)) {
            this.specialRules.put(operator2, new PrintRulesI(){
                private static final long serialVersionUID = 300L;

                public void append(Node node, PrintVisitor printVisitor) throws JepException {
                    node.jjtGetChild(0).jjtAccept(printVisitor, null);
                    node.jjtGetChild(1).jjtAccept(printVisitor, null);
                }
            });
        }
    }

    public void print(Node node, PrintStream printStream) {
        this.sb = new StringBuffer();
        try {
            node.jjtAccept(this, null);
        }
        catch (JepException jepException) {
            // empty catch block
        }
        this.printWrap(this.sb, printStream);
    }

    public void printWrap(StringBuffer stringBuffer, PrintStream printStream) {
        if (this.maxLen != -1) {
            while (true) {
                if (stringBuffer.length() < this.maxLen) {
                    printStream.print(stringBuffer);
                    return;
                }
                int n = this.maxLen - 2;
                for (int i = this.maxLen - 2; i >= 0; --i) {
                    char c = stringBuffer.charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '_' || c == '.') continue;
                    n = i;
                    break;
                }
                printStream.println(stringBuffer.substring(0, n + 1));
                stringBuffer.delete(0, n + 1);
            }
        }
        printStream.print(stringBuffer);
    }

    public void print(Node node) {
        this.print(node, System.out);
    }

    public void println(Node node, PrintStream printStream) {
        this.print(node, printStream);
        printStream.println("");
    }

    public void println(Node node) {
        this.println(node, System.out);
    }

    public String toString(Node node) {
        this.sb = new StringBuffer();
        try {
            node.jjtAccept(this, null);
        }
        catch (JepException jepException) {
            // empty catch block
        }
        return this.sb.toString();
    }

    public void append(String string) {
        this.sb.append(string);
    }

    public void addSpecialRule(Operator operator, PrintRulesI printRulesI) {
        this.specialRules.put(operator, printRulesI);
    }

    private void printNoBrackets(Node node) throws JepException {
        node.jjtAccept(this, null);
    }

    private void printBrackets(Node node) throws JepException {
        this.sb.append("(");
        this.printNoBrackets(node);
        this.sb.append(")");
    }

    private Object visitUnary(ASTOpNode aSTOpNode, Object object) throws JepException {
        Node node = aSTOpNode.jjtGetChild(0);
        if (aSTOpNode.getOperator().isPrefix()) {
            this.sb.append(aSTOpNode.getOperator().getSymbol());
        }
        if (node instanceof ASTOpNode) {
            this.printBrackets(node);
        } else {
            this.printNoBrackets(node);
        }
        if (aSTOpNode.getOperator().isSuffix()) {
            this.sb.append(aSTOpNode.getOperator().getSymbol());
        }
        return object;
    }

    private boolean testLeft(Operator operator, Node node) {
        if ((this.mode & 1) != 0) {
            return true;
        }
        if (node instanceof ASTOpNode) {
            Operator operator2 = ((ASTOpNode)node).getOperator();
            if (operator == operator2) {
                if (operator.isLeftBinding() && operator.isAssociative()) {
                    return false;
                }
                return !operator.useBindingForPrint();
            }
            if (operator.getPrecedence() == operator2.getPrecedence()) {
                if (operator2.isLeftBinding() && operator2.isAssociative()) {
                    return false;
                }
                return !operator2.useBindingForPrint();
            }
            return operator.getPrecedence() <= operator2.getPrecedence();
        }
        return false;
    }

    private boolean testMid(Operator operator, Node node) {
        if ((this.mode & 1) != 0) {
            return true;
        }
        if (node instanceof ASTOpNode) {
            Operator operator2 = ((ASTOpNode)node).getOperator();
            if (operator == operator2) {
                return false;
            }
            if (operator.getPrecedence() == operator2.getPrecedence()) {
                return false;
            }
            return operator.getPrecedence() <= operator2.getPrecedence();
        }
        return false;
    }

    private boolean testRight(Operator operator, Node node) {
        if ((this.mode & 1) != 0) {
            return true;
        }
        if (node instanceof ASTOpNode) {
            Operator operator2 = ((ASTOpNode)node).getOperator();
            if (operator == operator2) {
                return !operator.isRightBinding() && !operator.isAssociative();
            }
            if (operator.getPrecedence() == operator2.getPrecedence()) {
                return !operator.isLeftBinding() || !operator.isAssociative();
            }
            return operator.getPrecedence() <= operator2.getPrecedence();
        }
        return false;
    }

    private Object visitNaryBinary(ASTFunNode aSTFunNode, Operator operator) throws JepException {
        int n = aSTFunNode.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Node node;
            if (i > 0) {
                this.sb.append(operator.getSymbol());
            }
            if (this.testMid(operator, node = aSTFunNode.jjtGetChild(i))) {
                this.printBrackets(node);
                continue;
            }
            this.printNoBrackets(node);
        }
        return null;
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws JepException {
        this.sb.append(aSTFunNode.getName() + "(");
        for (int i = 0; i < aSTFunNode.jjtGetNumChildren(); ++i) {
            if (i > 0) {
                this.sb.append(",");
            }
            aSTFunNode.jjtGetChild(i).jjtAccept(this, null);
        }
        this.sb.append(")");
        return null;
    }

    public Object visit(ASTOpNode aSTOpNode, Object object) throws JepException {
        if (aSTOpNode instanceof PrintRulesI) {
            ((PrintRulesI)((Object)aSTOpNode)).append(aSTOpNode, this);
            return null;
        }
        if (aSTOpNode.getOperator() == null) {
            throw new JepException("Null operator in print for " + aSTOpNode);
        }
        if (this.specialRules.containsKey(aSTOpNode.getOperator())) {
            this.specialRules.get(aSTOpNode.getOperator()).append(aSTOpNode, this);
            return null;
        }
        if (aSTOpNode.getOperator().isUnary()) {
            return this.visitUnary(aSTOpNode, object);
        }
        if (aSTOpNode.getOperator().isBinary()) {
            Operator operator = aSTOpNode.getOperator();
            if (aSTOpNode.jjtGetNumChildren() != 2) {
                return this.visitNaryBinary(aSTOpNode, operator);
            }
            Node node = aSTOpNode.jjtGetChild(0);
            Node node2 = aSTOpNode.jjtGetChild(1);
            if (this.testLeft(operator, node)) {
                this.printBrackets(node);
            } else {
                this.printNoBrackets(node);
            }
            this.sb.append(aSTOpNode.getOperator().getSymbol());
            if (this.testRight(operator, node2)) {
                this.printBrackets(node2);
            } else {
                this.printNoBrackets(node2);
            }
        }
        return null;
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws JepException {
        this.sb.append(aSTVarNode.getName());
        return object;
    }

    public Object visit(ASTConstant aSTConstant, Object object) throws JepException {
        Object object2 = aSTConstant.getValue();
        this.formatValue(object2, this.sb);
        return object;
    }

    public void formatValue(Object object, StringBuffer stringBuffer) {
        if (this.format != null) {
            if (object instanceof Number) {
                this.format.format(object, stringBuffer, this.fp);
            } else if (object instanceof Complex) {
                if ((this.mode | 2) == 2) {
                    stringBuffer.append(((Complex)object).toString(this.format, true));
                } else {
                    stringBuffer.append(((Complex)object).toString(this.format));
                }
            } else {
                stringBuffer.append(object);
            }
        } else {
            stringBuffer.append(object);
        }
    }

    public String formatValue(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        this.formatValue(object, stringBuffer);
        return stringBuffer.toString();
    }

    public int getMode() {
        return this.mode;
    }

    public boolean getMode(int n) {
        return (this.mode | n) == n;
    }

    public void setMode(int n, boolean bl) {
        this.mode |= n;
        if (!bl) {
            this.mode ^= n;
        }
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.format = numberFormat;
    }

    public void setMaxLen(int n) {
        this.maxLen = n;
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public JepComponent getLightWeightInstance() {
        PrintVisitor printVisitor = new PrintVisitor();
        printVisitor.format = this.format;
        printVisitor.maxLen = this.maxLen;
        printVisitor.mode = this.mode;
        return printVisitor;
    }

    public static interface PrintRulesI
    extends Serializable {
        public void append(Node var1, PrintVisitor var2) throws JepException;
    }
}

