/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.Operator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorTable
implements JepComponent {
    private static final long serialVersionUID = 300L;
    protected Operator[] ops;
    public static final int OP_NOP = 0;
    public static final int OP_ADD = 1;
    public static final int OP_SUBTRACT = 2;
    public static final int OP_NEGATE = 3;
    public static final int OP_UPLUS = 4;
    public static final int OP_MULTIPLY = 5;
    public static final int OP_DIVIDE = 6;
    public static final int OP_MOD = 7;
    public static final int OP_RECIP = 8;
    public static final int OP_POWER = 9;
    public static final int OP_GT = 10;
    public static final int OP_LT = 11;
    public static final int OP_EQ = 12;
    public static final int OP_LE = 13;
    public static final int OP_GE = 14;
    public static final int OP_NE = 15;
    public static final int OP_AND = 16;
    public static final int OP_OR = 17;
    public static final int OP_NOT = 18;
    public static final int OP_ASSIGN = 19;
    public static final int OP_DOT = 20;
    public static final int OP_CROSS = 21;
    public static final int OP_LIST = 22;
    public static final int OP_ELEMENT = 23;
    public static final int OP_RANGE = 24;
    protected static final int baseNumOps = 25;
    protected int numOps = 25;

    @Override
    public void init(Jep jep) {
    }

    public void setNumOps(int n) {
        if (this.ops == null) {
            this.ops = new Operator[n];
        }
        if (this.ops.length <= n) {
            Operator[] operatorArray = this.ops;
            this.ops = new Operator[n];
            for (int i = 0; i < operatorArray.length; ++i) {
                this.ops[i] = operatorArray[i];
            }
        }
        this.numOps = this.ops.length;
    }

    public int getNumOps() {
        return this.numOps;
    }

    public Operator addOperator(int n, Operator operator) {
        this.setNumOps(n + 1);
        this.ops[n] = operator;
        operator.setKey(n);
        return operator;
    }

    public Operator addOperator(int n, Operator operator, Operator operator2) {
        this.addOperator(n, operator);
        operator.setPrecedence(operator2.getPrecedence());
        return operator;
    }

    public Operator insertOperator(int n, Operator operator, Operator operator2) {
        this.addOperator(n, operator);
        int n2 = operator2.getPrecedence();
        for (int i = 0; i < this.ops.length; ++i) {
            if (this.ops[i] == null || this.ops[i].getPrecedence() < n2) continue;
            this.ops[i].setPrecedence(this.ops[i].getPrecedence() + 1);
        }
        operator.setPrecedence(n2);
        return operator;
    }

    public Operator appendOperator(int n, Operator operator, Operator operator2) {
        this.addOperator(n, operator);
        int n2 = operator2.getPrecedence() + 1;
        for (int i = 0; i < this.ops.length; ++i) {
            if (this.ops[i] == null || this.ops[i].getPrecedence() < n2) continue;
            this.ops[i].setPrecedence(this.ops[i].getPrecedence() + 1);
        }
        operator.setPrecedence(n2);
        return operator;
    }

    public void removeOperator(Operator operator) {
        for (int i = 0; i < this.numOps; ++i) {
            if (this.ops[i] != operator) continue;
            this.ops[i] = null;
        }
    }

    public Operator getOperator(int n) {
        if (this.ops == null) {
            return null;
        }
        if (this.ops.length <= n) {
            return null;
        }
        return this.ops[n];
    }

    public List<Operator> getOperatorsBySymbol(String string) {
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        if (this.ops == null) {
            return arrayList;
        }
        for (int i = 0; i < this.ops.length; ++i) {
            if (this.ops[i] == null || !this.ops[i].getSymbol().equals(string)) continue;
            arrayList.add(this.ops[i]);
        }
        return arrayList;
    }

    public Operator getOperatorsByName(String string) {
        if (this.ops == null) {
            return null;
        }
        for (int i = 0; i < this.ops.length; ++i) {
            if (this.ops[i] == null || !this.ops[i].getName().equals(string)) continue;
            return this.ops[i];
        }
        return null;
    }

    public Collection<Operator> getOperators() {
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        if (this.ops == null) {
            return arrayList;
        }
        for (int i = 0; i < this.ops.length; ++i) {
            if (this.ops[i] == null) continue;
            arrayList.add(this.ops[i]);
        }
        return arrayList;
    }

    public final boolean setPrecedenceTable(int[][] nArray) {
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                Operator operator = this.getOperator(nArray[i][j]);
                if (operator != null) {
                    operator.setPrecedence(i);
                    continue;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected boolean setInverseOp(int n, int n2) {
        Operator operator = this.getOperator(n);
        Operator operator2 = this.getOperator(n2);
        if (operator == null || operator2 == null) {
            return false;
        }
        operator.setInverseOp(operator2);
        return true;
    }

    protected boolean setBinaryInverseOp(int n, int n2) {
        Operator operator = this.getOperator(n);
        Operator operator2 = this.getOperator(n2);
        if (operator == null || operator2 == null) {
            return false;
        }
        operator.setBinaryInverseOp(operator2);
        return true;
    }

    protected boolean setRootOp(int n, int n2) {
        Operator operator = this.getOperator(n);
        Operator operator2 = this.getOperator(n2);
        if (operator == null || operator2 == null) {
            return false;
        }
        operator.setRootOp(operator2);
        return true;
    }

    protected boolean setDistributiveOver(int n, int n2) {
        Operator operator = this.getOperator(n);
        Operator operator2 = this.getOperator(n2);
        if (operator == null || operator2 == null) {
            return false;
        }
        operator.setRootOp(operator2);
        return true;
    }

    protected void setStandardOperatorRelations() {
        this.setInverseOp(1, 3);
        this.setBinaryInverseOp(1, 2);
        this.setRootOp(2, 1);
        this.setInverseOp(2, 3);
        this.setRootOp(3, 1);
        this.setBinaryInverseOp(3, 2);
        this.setInverseOp(5, 8);
        this.setBinaryInverseOp(5, 6);
        this.setRootOp(6, 5);
        this.setInverseOp(6, 8);
        this.setRootOp(8, 5);
        this.setBinaryInverseOp(8, 6);
        this.setDistributiveOver(3, 1);
        this.setDistributiveOver(3, 2);
        this.setDistributiveOver(5, 1);
        this.setDistributiveOver(5, 2);
        this.setDistributiveOver(5, 3);
    }

    public Operator getNop() {
        return this.ops[0];
    }

    public Operator getAdd() {
        return this.ops[1];
    }

    public Operator getSubtract() {
        return this.ops[2];
    }

    public Operator getUMinus() {
        return this.ops[3];
    }

    public Operator getUPlus() {
        return this.ops[4];
    }

    public Operator getMultiply() {
        return this.ops[5];
    }

    public Operator getDivide() {
        return this.ops[6];
    }

    public Operator getMod() {
        return this.ops[7];
    }

    public Operator getUDivide() {
        return this.ops[8];
    }

    public Operator getPower() {
        return this.ops[9];
    }

    public Operator getGT() {
        return this.ops[10];
    }

    public Operator getLT() {
        return this.ops[11];
    }

    public Operator getEQ() {
        return this.ops[12];
    }

    public Operator getLE() {
        return this.ops[13];
    }

    public Operator getGE() {
        return this.ops[14];
    }

    public Operator getNE() {
        return this.ops[15];
    }

    public Operator getAnd() {
        return this.ops[16];
    }

    public Operator getOr() {
        return this.ops[17];
    }

    public Operator getNot() {
        return this.ops[18];
    }

    public Operator getAssign() {
        return this.ops[19];
    }

    public Operator getDot() {
        return this.ops[20];
    }

    public Operator getCross() {
        return this.ops[21];
    }

    public Operator getList() {
        return this.ops[22];
    }

    public Operator getEle() {
        return this.ops[23];
    }

    public Operator getRange() {
        return this.ops[24];
    }

    public String toString() {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (n2 = 0; n2 < this.numOps; ++n2) {
            if (this.ops[n2] == null) continue;
            n = this.ops[n2].getPrecedence();
            if (n < n3) {
                n3 = n;
            }
            if (n <= n4) continue;
            n4 = n;
        }
        for (n2 = n3; n2 <= n4; ++n2) {
            for (n = 0; n < this.numOps; ++n) {
                if (this.ops[n] == null || this.ops[n].getPrecedence() != n2) continue;
                stringBuilder.append(this.ops[n].toFullString());
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return this;
    }
}

