/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.PostfixMathCommandI;
import java.io.Serializable;

public class Operator
implements Serializable {
    private static final long serialVersionUID = 300L;
    public static final int NO_ARGS = 0;
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    public static final int NARY = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int ASSOCIATIVE = 16;
    public static final int COMMUTATIVE = 32;
    public static final int REFLEXIVE = 64;
    public static final int SYMMETRIC = 128;
    public static final int TRANSITIVE = 256;
    public static final int EQUIVALENCE = 448;
    public static final int PREFIX = 512;
    public static final int SUFFIX = 1024;
    public static final int SELF_INVERSE = 2048;
    public static final int COMPOSITE = 4096;
    public static final int USE_BINDING_FOR_PRINT = 8192;
    public static final int NOT_IN_PARSER = 16384;
    public static final int TERNARY = 32768;
    private String name;
    private String symbol;
    private PostfixMathCommandI pfmc;
    public int flags;
    private int precedence = -1;
    private int key;
    private Operator[] distribOver = new Operator[0];
    private Operator rootOperator = null;
    private Operator inverseOperator = null;
    private Operator binaryInverseOperator = null;

    public Operator(String string, PostfixMathCommandI postfixMathCommandI, int n) {
        this.name = string;
        this.pfmc = postfixMathCommandI;
        this.symbol = string;
        this.flags = n;
    }

    public Operator(String string, PostfixMathCommandI postfixMathCommandI, int n, int n2) {
        this(string, postfixMathCommandI, n);
        this.precedence = n2;
    }

    public Operator(String string, String string2, PostfixMathCommandI postfixMathCommandI, int n) {
        this.name = string;
        this.pfmc = postfixMathCommandI;
        this.symbol = string2;
        this.flags = n;
    }

    public Operator(String string, String string2, PostfixMathCommandI postfixMathCommandI, int n, int n2) {
        this.name = string;
        this.pfmc = postfixMathCommandI;
        this.symbol = string2;
        this.precedence = n2;
        this.flags = n;
    }

    public final String getSymbol() {
        return this.symbol;
    }

    public final String getName() {
        return this.name;
    }

    public final PostfixMathCommandI getPFMC() {
        return this.pfmc;
    }

    public final void setPFMC(PostfixMathCommandI postfixMathCommandI) {
        this.pfmc = postfixMathCommandI;
    }

    public final int getPrecedence() {
        return this.precedence;
    }

    public final void setPrecedence(int n) {
        this.precedence = n;
    }

    public final void setDistributiveOver(Operator operator) {
        int n = this.distribOver.length;
        Operator[] operatorArray = new Operator[n + 1];
        for (int i = 0; i < n; ++i) {
            operatorArray[i] = this.distribOver[i];
        }
        operatorArray[n] = operator;
        this.distribOver = operatorArray;
    }

    public boolean isDistributiveOver(Operator operator) {
        for (int i = 0; i < this.distribOver.length; ++i) {
            if (operator != this.distribOver[i]) continue;
            return true;
        }
        return false;
    }

    public void setRootOp(Operator operator) {
        this.rootOperator = operator;
    }

    public void setInverseOp(Operator operator) {
        this.inverseOperator = operator;
    }

    public void setBinaryInverseOp(Operator operator) {
        this.binaryInverseOperator = operator;
    }

    public Operator getRootOp() {
        return this.rootOperator;
    }

    public Operator getInverseOp() {
        return this.inverseOperator;
    }

    public Operator getBinaryInverseOp() {
        return this.binaryInverseOperator;
    }

    @Deprecated
    public final int getBinding() {
        return this.flags & 0xC;
    }

    public final boolean isLeftBinding() {
        return (this.flags & 4) == 4;
    }

    public final boolean isRightBinding() {
        return (this.flags & 8) == 8;
    }

    public final boolean isAssociative() {
        return (this.flags & 0x10) == 16;
    }

    public final boolean isCommutative() {
        return (this.flags & 0x20) == 32;
    }

    public final boolean isBinary() {
        return (this.flags & 3) == 2;
    }

    public final boolean isUnary() {
        return (this.flags & 3) == 1;
    }

    public final boolean isNary() {
        return (this.flags & 3) == 3;
    }

    public final int numArgs() {
        return this.flags & 3;
    }

    public final boolean isTransitive() {
        return (this.flags & 0x100) == 256;
    }

    public final boolean isSymmetric() {
        return (this.flags & 0x80) == 128;
    }

    public final boolean isReflexive() {
        return (this.flags & 0x40) == 64;
    }

    public final boolean isEquivalence() {
        return (this.flags & 0x1C0) == 448;
    }

    public final boolean isPrefix() {
        return (this.flags & 0x200) == 512;
    }

    public final boolean isSuffix() {
        return (this.flags & 0x400) == 1024;
    }

    public final boolean isTernary() {
        return (this.flags & 0x8000) == 32768;
    }

    public final boolean isComposite() {
        return (this.flags & 0x1000) == 4096;
    }

    public final boolean isSelfInverse() {
        return (this.flags & 0x800) == 2048;
    }

    public final boolean useBindingForPrint() {
        return (this.flags & 0x2000) == 8192;
    }

    public final boolean notInParser() {
        return (this.flags & 0x4000) == 16384;
    }

    public String toFullString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Operator: \"" + this.getSymbol() + "\"");
        if (!this.getName().equals(this.getSymbol())) {
            stringBuffer.append(" " + this.getName());
        }
        switch (this.numArgs()) {
            case 0: {
                stringBuffer.append(" no arguments,");
                break;
            }
            case 1: {
                stringBuffer.append(" unary,");
                break;
            }
            case 2: {
                stringBuffer.append(" binary,");
                break;
            }
            case 3: {
                stringBuffer.append(" variable number of arguments,");
            }
        }
        if (this.isTernary()) {
            stringBuffer.append(" ternary,");
        } else if (this.isPrefix()) {
            stringBuffer.append(" prefix,");
        } else if (this.isSuffix()) {
            stringBuffer.append(" suffix,");
        } else {
            stringBuffer.append(" infix,");
        }
        if (this.getBinding() == 4) {
            stringBuffer.append(" left binding,");
        } else if (this.getBinding() == 8) {
            stringBuffer.append(" right binding,");
        }
        if (this.isAssociative()) {
            stringBuffer.append(" associative,");
        }
        if (this.isCommutative()) {
            stringBuffer.append(" commutative,");
        }
        stringBuffer.append(" precedence " + this.getPrecedence() + ",");
        if (this.isEquivalence()) {
            stringBuffer.append(" equivalence relation,");
        } else {
            if (this.isReflexive()) {
                stringBuffer.append(" reflexive,");
            }
            if (this.isSymmetric()) {
                stringBuffer.append(" symmetric,");
            }
            if (this.isTransitive()) {
                stringBuffer.append(" transitive,");
            }
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, '.');
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toFullString();
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int n) {
        this.key = n;
    }
}

