/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.Variable;
import com.singularsys.jep.VariableTable;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;

public class NodeFactory
implements JepComponent {
    private static final long serialVersionUID = 300L;
    protected transient Evaluator ev;
    protected transient VariableTable vt;
    protected transient Jep j;

    public void init(Jep jep) {
        this.j = jep;
        this.ev = this.j.getEvaluator();
        this.vt = this.j.getVariableTable();
    }

    public void copyChildren(Node node, Node[] nodeArray) {
        int n = nodeArray.length;
        node.jjtOpen();
        for (int i = 0; i < n; ++i) {
            nodeArray[i].jjtSetParent(node);
            node.jjtAddChild(nodeArray[i], i);
        }
        node.jjtClose();
    }

    public ASTConstant buildConstantNode(Object object) throws JepException {
        ASTConstant aSTConstant = new ASTConstant(5);
        aSTConstant.setValue(object);
        return aSTConstant;
    }

    public ASTConstant buildConstantNode(ASTConstant aSTConstant) throws JepException {
        return this.buildConstantNode(aSTConstant.getValue());
    }

    public ASTConstant buildConstantNode(PostfixMathCommandI postfixMathCommandI, Node[] nodeArray) throws IllegalArgumentException, JepException {
        ASTFunNode aSTFunNode = this.buildFunctionNode("tmpfun", postfixMathCommandI, nodeArray);
        Object object = this.ev.eval(aSTFunNode);
        return this.buildConstantNode(object);
    }

    public ASTConstant buildConstantNode(Operator operator, Node[] nodeArray) throws IllegalArgumentException, JepException {
        return this.buildConstantNode(operator.getPFMC(), nodeArray);
    }

    public ASTConstant buildConstantNode(Operator operator, Node node, Node node2) throws IllegalArgumentException, JepException {
        return this.buildConstantNode(operator.getPFMC(), new Node[]{node, node2});
    }

    public ASTConstant buildConstantNode(Operator operator, Node node) throws IllegalArgumentException, JepException {
        return this.buildConstantNode(operator.getPFMC(), new Node[]{node});
    }

    public ASTVarNode buildVariableNode(ASTVarNode aSTVarNode) throws JepException {
        return this.buildVariableNode(aSTVarNode.getVar());
    }

    public ASTVarNode buildVariableNode(Variable variable) throws JepException {
        ASTVarNode aSTVarNode = new ASTVarNode(3);
        aSTVarNode.setVar(variable);
        return aSTVarNode;
    }

    public ASTVarNode buildVariableNode(String string, Object object) throws JepException {
        ASTVarNode aSTVarNode = new ASTVarNode(3);
        Variable variable = this.vt.addVariable(string, object);
        aSTVarNode.setVar(variable);
        return this.buildVariableNode(variable);
    }

    public ASTVarNode buildVariableNode(String string) throws JepException {
        ASTVarNode aSTVarNode = new ASTVarNode(3);
        Variable variable = this.vt.addVariable(string);
        aSTVarNode.setVar(variable);
        return this.buildVariableNode(variable);
    }

    public ASTVarNode buildVariableNodeCheckUndeclared(String string) throws JepException {
        if (this.j.getAllowUndeclared() || this.vt.getVariable(string) != null) {
            return this.buildVariableNode(string);
        }
        throw new JepException("Variable '" + string + "' undefined. Use jep.setAllowUndeclared() to allow undeclared variables.");
    }

    public ASTOpNode buildOperatorNode(Operator operator, Node[] nodeArray) throws JepException {
        ASTOpNode aSTOpNode = new ASTOpNode(4);
        aSTOpNode.setOperator(operator);
        this.copyChildren(aSTOpNode, nodeArray);
        return aSTOpNode;
    }

    public ASTFunNode buildFunctionNode(String string, PostfixMathCommandI postfixMathCommandI, Node[] nodeArray) throws JepException {
        if (!postfixMathCommandI.checkNumberOfParameters(nodeArray.length)) {
            throw new JepException("Incorrect number of parameters " + nodeArray.length + " for " + string + " ");
        }
        ASTFunNode aSTFunNode = new ASTFunNode(4);
        aSTFunNode.setFunction(string, postfixMathCommandI);
        this.copyChildren(aSTFunNode, nodeArray);
        return aSTFunNode;
    }

    public ASTOpNode buildUnfinishedOperatorNode(Operator operator) {
        ASTOpNode aSTOpNode = new ASTOpNode(4);
        aSTOpNode.setOperator(operator);
        return aSTOpNode;
    }

    public ASTOpNode buildOperatorNode(Operator operator, Node node) throws JepException {
        return this.buildOperatorNode(operator, new Node[]{node});
    }

    public ASTOpNode buildOperatorNode(Operator operator, Node node, Node node2) throws JepException {
        return this.buildOperatorNode(operator, new Node[]{node, node2});
    }

    public ASTFunNode buildFunctionNode(ASTFunNode aSTFunNode, Node[] nodeArray) throws JepException {
        return this.buildFunctionNode(aSTFunNode.getName(), aSTFunNode.getPFMC(), nodeArray);
    }

    public JepComponent getLightWeightInstance() {
        return new NodeFactory();
    }
}

