/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.ComponentSet;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.OperatorTable;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Parser;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.PrintVisitor;
import com.singularsys.jep.Variable;
import com.singularsys.jep.VariableFactory;
import com.singularsys.jep.VariableTable;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import com.singularsys.jep.standard.StandardComponents;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;

public class Jep
implements Serializable {
    private transient int pcount = 0;
    private static final long serialVersionUID = 301L;
    protected NumberFactory numFac;
    protected VariableFactory varFac;
    protected NodeFactory nodeFac;
    protected VariableTable varTab;
    protected FunctionTable funTab;
    protected OperatorTable opTab;
    protected PrintVisitor pv;
    protected transient Node lastRootNode = null;
    protected Parser parser;
    protected Evaluator evaluator;
    protected boolean implicitMul = true;
    protected boolean allowUndeclared = true;
    protected boolean allowAssignment = true;

    public Jep() {
        this(new StandardComponents());
    }

    public Jep(ComponentSet componentSet) {
        this(componentSet.getComponents());
    }

    public Jep(JepComponent[] jepComponentArray) {
        this.setComponents(jepComponentArray);
    }

    public void setComponents(JepComponent[] jepComponentArray) {
        for (JepComponent jepComponent : jepComponentArray) {
            if (jepComponent instanceof NumberFactory) {
                this.numFac = (NumberFactory)jepComponent;
                continue;
            }
            if (jepComponent instanceof VariableFactory) {
                this.varFac = (VariableFactory)jepComponent;
                continue;
            }
            if (jepComponent instanceof NodeFactory) {
                this.nodeFac = (NodeFactory)jepComponent;
                continue;
            }
            if (jepComponent instanceof VariableTable) {
                this.varTab = (VariableTable)jepComponent;
                continue;
            }
            if (jepComponent instanceof FunctionTable) {
                this.funTab = (FunctionTable)jepComponent;
                continue;
            }
            if (jepComponent instanceof OperatorTable) {
                this.opTab = (OperatorTable)jepComponent;
                continue;
            }
            if (jepComponent instanceof Parser) {
                this.parser = (Parser)jepComponent;
                continue;
            }
            if (jepComponent instanceof Evaluator) {
                this.evaluator = (Evaluator)jepComponent;
                continue;
            }
            if (!(jepComponent instanceof PrintVisitor)) continue;
            this.pv = (PrintVisitor)jepComponent;
        }
        this.reinitializeComponents();
    }

    public void reinitializeComponents() {
        this.numFac.init(this);
        this.nodeFac.init(this);
        this.varFac.init(this);
        this.varTab.init(this);
        this.funTab.init(this);
        this.opTab.init(this);
        this.parser.init(this);
        this.evaluator.init(this);
        this.pv.init(this);
    }

    public void setComponent(JepComponent jepComponent) {
        this.setComponents(new JepComponent[]{jepComponent});
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.reinitializeComponents();
    }

    public NumberFactory getNumberFactory() {
        return this.numFac;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFac;
    }

    public VariableFactory getVariableFactory() {
        return this.varFac;
    }

    public FunctionTable getFunctionTable() {
        return this.funTab;
    }

    public OperatorTable getOperatorTable() {
        return this.opTab;
    }

    public VariableTable getVariableTable() {
        return this.varTab;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public PrintVisitor getPrintVisitor() {
        return this.pv;
    }

    public Variable addVariable(String string) {
        return this.varTab.addVariable(string);
    }

    public Variable addVariable(String string, Object object) {
        return this.varTab.addVariable(string, object);
    }

    public Variable addVariable(String string, double d) {
        return this.varTab.addVariable(string, new Double(d));
    }

    public Variable addVariable(String string, double d, double d2) {
        return this.varTab.addVariable(string, new Complex(d, d2));
    }

    public boolean addStandardConstants() {
        try {
            this.varTab.addVariable("pi", this.numFac.createNumber(Math.PI));
            this.varTab.addVariable("e", this.numFac.createNumber(Math.E));
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public Variable getVariable(String string) {
        return this.varTab.getVariable(string);
    }

    public Object getVariableValue(String string) {
        Variable variable = this.varTab.getVariable(string);
        if (variable != null) {
            return variable.getValue();
        }
        return null;
    }

    public void setAllowAssignment(boolean bl) {
        this.allowAssignment = bl;
    }

    public boolean getAllowAssignment() {
        return this.allowAssignment;
    }

    public void setAllowUndeclared(boolean bl) {
        this.allowUndeclared = bl;
    }

    public boolean getAllowUndeclared() {
        return this.allowUndeclared;
    }

    public void setImplicitMul(boolean bl) {
        this.implicitMul = bl;
    }

    public boolean getImplicitMul() {
        return this.implicitMul;
    }

    public PostfixMathCommandI addFunction(String string, PostfixMathCommandI postfixMathCommandI) {
        return this.funTab.addFunction(string, postfixMathCommandI);
    }

    public Node getLastRootNode() {
        return this.lastRootNode;
    }

    public Node parse(Reader reader) throws ParseException {
        if (this.pcount++ > 50) {
            throw new ParseException("Trial version limitation: Number of parse calls exceeded");
        }
        this.lastRootNode = this.parser.parse(reader);
        return this.lastRootNode;
    }

    public Node parse(String string) throws ParseException {
        return this.parse(new StringReader(string));
    }

    public double evaluateD() throws EvaluationException {
        Object object = this.evaluate(this.lastRootNode);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return new Double((Boolean)object != false ? 1.0 : 0.0);
        }
        throw new EvaluationException("Result could not be converted to the double type");
    }

    public Object evaluate() throws EvaluationException {
        return this.evaluate(this.lastRootNode);
    }

    public Object evaluate(Node node) throws EvaluationException {
        if (node != null) {
            Object object = this.evaluator.evaluate(node);
            return object;
        }
        return null;
    }

    public void print(Node node, PrintStream printStream) {
        this.pv.print(node, printStream);
    }

    public void print(Node node) {
        this.pv.print(node);
    }

    public void print() {
        this.pv.print(this.lastRootNode);
    }

    public void println(Node node, PrintStream printStream) {
        this.pv.println(node, printStream);
    }

    public void println(Node node) {
        this.pv.println(node);
    }

    public void println() {
        this.pv.println(this.lastRootNode);
    }

    public String toString(Node node) {
        return this.pv.toString(node);
    }

    public String rootNodeToString() {
        return this.pv.toString(this.lastRootNode);
    }
}

